/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.HashMap;
import java.util.Map;
import net.minestom.server.codec.Codec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.NetworkBuffer;

public record ItemBlockState(Map<String, String> properties) {
    public static final ItemBlockState EMPTY = new ItemBlockState(Map.of());
    public static final NetworkBuffer.Type<ItemBlockState> NETWORK_TYPE = NetworkBuffer.STRING.mapValue(NetworkBuffer.STRING).transform(ItemBlockState::new, ItemBlockState::properties);
    public static final Codec<ItemBlockState> CODEC = Codec.STRING.mapValue(Codec.STRING).transform(ItemBlockState::new, ItemBlockState::properties);

    public ItemBlockState {
        properties = Map.copyOf(properties);
    }

    public ItemBlockState(String key, String value) {
        this(Map.of(key, value));
    }

    public ItemBlockState with(String key, String value) {
        HashMap<String, String> newProperties = new HashMap<String, String>(this.properties);
        newProperties.put(key, value);
        return new ItemBlockState(newProperties);
    }

    public Block apply(Block block) {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (block.getProperty(entry.getKey()) == null) continue;
            block = block.withProperty(entry.getKey(), entry.getValue());
        }
        return block;
    }
}

