/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.map.framebuffers;

import net.minestom.server.map.Framebuffer;
import net.minestom.server.map.LargeFramebuffer;
import net.minestom.server.map.MapColors;

public class LargeFramebufferDefaultView
implements Framebuffer {
    private final LargeFramebuffer parent;
    private final int x;
    private final int y;
    private final byte[] colors = new byte[16384];

    public LargeFramebufferDefaultView(LargeFramebuffer parent, int x, int y) {
        this.parent = parent;
        this.x = x;
        this.y = y;
    }

    private boolean bounds(int x, int y) {
        return x >= 0 && x < this.parent.width() && y >= 0 && y < this.parent.height();
    }

    private byte colorOrNone(int x, int y) {
        if (!this.bounds(x, y)) {
            return MapColors.NONE.baseColor();
        }
        return this.parent.getMapColor(x, y);
    }

    @Override
    public byte[] toMapColors() {
        for (int y = 0; y < 128; ++y) {
            for (int x = 0; x < 128; ++x) {
                this.colors[Framebuffer.index((int)x, (int)y)] = this.colorOrNone(x + this.x, y + this.y);
            }
        }
        return this.colors;
    }
}

