/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.message;

import java.util.EnumSet;
import net.minestom.server.message.ChatPosition;

public enum ChatMessageType {
    FULL(EnumSet.allOf(ChatPosition.class)),
    SYSTEM(EnumSet.of(ChatPosition.SYSTEM_MESSAGE, ChatPosition.GAME_INFO)),
    NONE(EnumSet.of(ChatPosition.GAME_INFO));

    private final EnumSet<ChatPosition> acceptedPositions;

    private ChatMessageType(EnumSet<ChatPosition> acceptedPositions) {
        this.acceptedPositions = acceptedPositions;
    }

    public boolean accepts(ChatPosition chatPosition) {
        return this.acceptedPositions.contains((Object)chatPosition);
    }

    public int getPacketID() {
        return this.ordinal();
    }

    public static ChatMessageType fromPacketID(int id) {
        return switch (id) {
            case 0 -> FULL;
            case 1 -> SYSTEM;
            case 2 -> NONE;
            default -> throw new IllegalArgumentException("id must be between 0-2 (inclusive)");
        };
    }
}

