/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.debug;

import java.util.Collection;
import net.kyori.adventure.key.Key;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.debug.DebugSubscriptionImpl;
import net.minestom.server.network.debug.DebugSubscriptions;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.Nullable;

public sealed interface DebugSubscription<T>
extends StaticProtocolObject<DebugSubscription<T>>,
DebugSubscriptions
permits DebugSubscriptionImpl {
    public static final NetworkBuffer.Type<DebugSubscription<?>> NETWORK_TYPE = NetworkBuffer.VAR_INT.transform(DebugSubscription::fromId, DebugSubscription::id);

    @Override
    public int id();

    @Override
    public Key key();

    @Nullable
    public static DebugSubscription<?> fromKey(String key) {
        return DebugSubscriptionImpl.NAMESPACES.get(key);
    }

    @Nullable
    public static DebugSubscription<?> fromKey(Key key) {
        return DebugSubscription.fromKey(key.asString());
    }

    @Nullable
    public static DebugSubscription<?> fromId(int id) {
        return DebugSubscriptionImpl.IDS.get(id);
    }

    public static Collection<DebugSubscription<?>> values() {
        return DebugSubscriptionImpl.NAMESPACES.values();
    }

    public record Update<T>(DebugSubscription<T> subscription, @Nullable T value) {
        public static final NetworkBuffer.Type<Update<?>> NETWORK_TYPE = new NetworkBuffer.Type<Update<?>>(){

            @Override
            public void write(NetworkBuffer buffer, Update<?> value) {
                buffer.write(DebugSubscription.NETWORK_TYPE, value.subscription);
                buffer.write(NetworkBuffer.BOOLEAN, value.value != null);
                if (value.value != null) {
                    ((DebugSubscriptionImpl)value.subscription).write(buffer, value.value);
                }
            }

            @Override
            public Update<?> read(NetworkBuffer buffer) {
                DebugSubscriptionImpl subscription = (DebugSubscriptionImpl)buffer.read(DebugSubscription.NETWORK_TYPE);
                boolean hasValue = buffer.read(NetworkBuffer.BOOLEAN);
                Object value = hasValue ? (Object)subscription.read(buffer) : null;
                return new Update<Object>(subscription, value);
            }
        };
    }

    public record Event<T>(DebugSubscription<T> subscription, T value) {
        public static final NetworkBuffer.Type<Event<?>> NETWORK_TYPE = new NetworkBuffer.Type<Event<?>>(){

            @Override
            public void write(NetworkBuffer buffer, Event<?> value) {
                buffer.write(DebugSubscription.NETWORK_TYPE, value.subscription);
                ((DebugSubscriptionImpl)value.subscription).write(buffer, value.value);
            }

            @Override
            public Event<?> read(NetworkBuffer buffer) {
                DebugSubscriptionImpl subscription = (DebugSubscriptionImpl)buffer.read(DebugSubscription.NETWORK_TYPE);
                Object value = subscription.read(buffer);
                return new Event(subscription, value);
            }
        };
    }
}

