/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.debug;

import java.util.List;
import net.kyori.adventure.key.Key;
import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.debug.DebugSubscription;
import net.minestom.server.network.debug.DebugSubscriptionImpl;
import net.minestom.server.network.debug.info.DebugBeeInfo;
import net.minestom.server.network.debug.info.DebugBrainDump;
import net.minestom.server.network.debug.info.DebugBreezeInfo;
import net.minestom.server.network.debug.info.DebugEntityBlockIntersection;
import net.minestom.server.network.debug.info.DebugGameEventInfo;
import net.minestom.server.network.debug.info.DebugGameEventListenerInfo;
import net.minestom.server.network.debug.info.DebugGoalInfo;
import net.minestom.server.network.debug.info.DebugHiveInfo;
import net.minestom.server.network.debug.info.DebugPathInfo;
import net.minestom.server.network.debug.info.DebugPoiInfo;
import net.minestom.server.network.debug.info.DebugStructureInfo;
import net.minestom.server.utils.Unit;

sealed interface DebugSubscriptions
permits DebugSubscription {
    public static final DebugSubscription<Unit> DEDICATED_SERVER_TICK_TIME = DebugSubscriptions.register("dedicated_server_tick_time");
    public static final DebugSubscription<DebugBeeInfo> BEES = DebugSubscriptions.register("bees", DebugBeeInfo.SERIALIZER);
    public static final DebugSubscription<DebugBrainDump> BRAINS = DebugSubscriptions.register("brains", DebugBrainDump.SERIALIZER);
    public static final DebugSubscription<DebugBreezeInfo> BREEZES = DebugSubscriptions.register("breezes", DebugBreezeInfo.SERIALIZER);
    public static final DebugSubscription<List<DebugGoalInfo>> GOAL_SELECTORS = DebugSubscriptions.register("goal_selectors", DebugGoalInfo.SERIALIZER.list());
    public static final DebugSubscription<DebugPathInfo> ENTITY_PATHS = DebugSubscriptions.register("entity_paths", DebugPathInfo.SERIALIZER);
    public static final DebugSubscription<DebugEntityBlockIntersection> ENTITY_BLOCK_INTERSECTIONS = DebugSubscriptions.register("entity_block_intersections", DebugEntityBlockIntersection.SERIALIZER);
    public static final DebugSubscription<DebugHiveInfo> BEE_HIVES = DebugSubscriptions.register("bee_hives", DebugHiveInfo.SERIALIZER);
    public static final DebugSubscription<DebugPoiInfo> POIS = DebugSubscriptions.register("pois", DebugPoiInfo.SERIALIZER);
    public static final DebugSubscription<Integer> REDSTONE_WIRE_ORIENTATIONS = DebugSubscriptions.register("redstone_wire_orientations", NetworkBuffer.VAR_INT);
    public static final DebugSubscription<Unit> VILLAGE_SECTIONS = DebugSubscriptions.register("village_sections");
    public static final DebugSubscription<List<Point>> RAIDS = DebugSubscriptions.register("raids", NetworkBuffer.BLOCK_POSITION.list());
    public static final DebugSubscription<List<DebugStructureInfo>> STRUCTURES = DebugSubscriptions.register("structures", DebugStructureInfo.SERIALIZER.list());
    public static final DebugSubscription<DebugGameEventListenerInfo> GAME_EVENT_LISTENERS = DebugSubscriptions.register("game_event_listeners", DebugGameEventListenerInfo.SERIALIZER);
    public static final DebugSubscription<Point> NEIGHBOR_UPDATES = DebugSubscriptions.register("neighbor_updates", NetworkBuffer.BLOCK_POSITION);
    public static final DebugSubscription<DebugGameEventInfo> GAME_EVENTS = DebugSubscriptions.register("game_events", DebugGameEventInfo.SERIALIZER);

    private static DebugSubscription<Unit> register(String name) {
        return DebugSubscriptions.register(name, NetworkBuffer.UNIT);
    }

    private static <T> DebugSubscription<T> register(String name, NetworkBuffer.Type<T> networkType) {
        DebugSubscriptionImpl<T> impl = new DebugSubscriptionImpl<T>(DebugSubscriptionImpl.NAMESPACES.size(), Key.key(name), networkType);
        DebugSubscriptionImpl.NAMESPACES.put(impl.name(), impl);
        DebugSubscriptionImpl.IDS.set(impl.id(), impl);
        return impl;
    }
}

