/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.zip.DataFormatException;
import net.minestom.server.ServerFlag;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.PacketParser;
import net.minestom.server.network.packet.PacketRegistry;
import net.minestom.server.network.packet.PacketVanilla;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class PacketReading {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketReading.class);
    private static final int MAX_VAR_INT_SIZE = 5;
    private static final Result.Empty EMPTY_CLIENT_PACKET = new Result.Empty();

    public static Result<ClientPacket> readClients(NetworkBuffer buffer, ConnectionState state, boolean compressed) throws DataFormatException {
        return PacketReading.readPackets(buffer, PacketVanilla.CLIENT_PACKET_PARSER, state, PacketVanilla::nextClientState, compressed);
    }

    public static Result<ServerPacket> readServers(NetworkBuffer buffer, ConnectionState state, boolean compressed) throws DataFormatException {
        return PacketReading.readPackets(buffer, PacketVanilla.SERVER_PACKET_PARSER, state, PacketVanilla::nextServerState, compressed);
    }

    public static <T> Result<T> readPackets(NetworkBuffer buffer, PacketParser<T> parser, ConnectionState state, BiFunction<T, ConnectionState, ConnectionState> stateUpdater, boolean compressed) throws DataFormatException {
        ArrayList packets = new ArrayList();
        block5: while (buffer.readableBytes() > 0L) {
            Result<T> result;
            Result<T> result2 = PacketReading.readPacket(buffer, parser, state, stateUpdater, compressed);
            if (buffer.readableBytes() == 0L && packets.isEmpty()) {
                return result2;
            }
            Objects.requireNonNull(result2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Success.class, Result.Empty.class, Result.Failure.class}, result, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Result.Success success = (Result.Success)result;
                    assert (success.packets().size() == 1);
                    ParsedPacket parsedPacket = success.packets().getFirst();
                    packets.add(parsedPacket);
                    state = parsedPacket.nextState();
                    break;
                }
                case 1: {
                    Result.Empty ignored = (Result.Empty)result;
                    break block5;
                }
                case 2: {
                    Result.Failure failure = (Result.Failure)result;
                    return packets.isEmpty() ? failure : new Result.Success(packets);
                }
            }
        }
        return !packets.isEmpty() ? new Result.Success(packets) : EMPTY_CLIENT_PACKET;
    }

    public static Result<ClientPacket> readClient(NetworkBuffer buffer, ConnectionState state, boolean compressed) throws DataFormatException {
        return PacketReading.readPacket(buffer, PacketVanilla.CLIENT_PACKET_PARSER, state, PacketVanilla::nextClientState, compressed);
    }

    public static Result<ServerPacket> readServer(NetworkBuffer buffer, ConnectionState state, boolean compressed) throws DataFormatException {
        return PacketReading.readPacket(buffer, PacketVanilla.SERVER_PACKET_PARSER, state, PacketVanilla::nextServerState, compressed);
    }

    public static <T> Result<T> readPacket(NetworkBuffer buffer, PacketParser<T> parser, ConnectionState state, BiFunction<T, ConnectionState, ConnectionState> stateUpdater, boolean compressed) throws DataFormatException {
        int packetLength;
        long beginMark = buffer.readIndex();
        try {
            packetLength = buffer.read(NetworkBuffer.VAR_INT);
        }
        catch (IndexOutOfBoundsException e) {
            return new Result.Failure(5L);
        }
        long readerStart = buffer.readIndex();
        if (readerStart > buffer.writeIndex()) {
            buffer.readIndex(beginMark);
            return EMPTY_CLIENT_PACKET;
        }
        int maxPacketSize = PacketReading.maxPacketSize(state);
        if (packetLength > maxPacketSize) {
            throw new DataFormatException("Packet too large: " + packetLength);
        }
        if (buffer.readableBytes() < (long)packetLength) {
            buffer.readIndex(beginMark);
            long packetLengthVarIntSize = readerStart - beginMark;
            long requiredCapacity = packetLengthVarIntSize + (long)packetLength;
            if (requiredCapacity > buffer.capacity()) {
                return new Result.Failure(requiredCapacity);
            }
            return EMPTY_CLIENT_PACKET;
        }
        long readerEnd = readerStart + (long)packetLength;
        long writerEnd = buffer.writeIndex();
        buffer.writeIndex(readerEnd);
        PacketRegistry<T> registry = parser.stateRegistry(state);
        T packet = PacketReading.readFramedPacket(buffer, registry, compressed);
        ConnectionState nextState = stateUpdater.apply(packet, state);
        buffer.index(readerEnd, writerEnd);
        return new Result.Success<T>(new ParsedPacket<T>(nextState, packet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T readFramedPacket(NetworkBuffer buffer, PacketRegistry<T> registry, boolean compressed) throws DataFormatException {
        if (!compressed) {
            return PacketReading.readPayload(buffer, registry);
        }
        int dataLength = buffer.read(NetworkBuffer.VAR_INT);
        if (dataLength == 0) {
            return PacketReading.readPayload(buffer, registry);
        }
        NetworkBuffer decompressed = PacketVanilla.PACKET_POOL.get();
        try {
            if (decompressed.capacity() < (long)dataLength) {
                decompressed.resize(dataLength);
            }
            buffer.decompress(buffer.readIndex(), buffer.readableBytes(), decompressed);
            T t = PacketReading.readPayload(decompressed, registry);
            return t;
        }
        finally {
            PacketVanilla.PACKET_POOL.add(decompressed);
        }
    }

    private static <T> T readPayload(NetworkBuffer buffer, PacketRegistry<T> registry) {
        int packetId = buffer.read(NetworkBuffer.VAR_INT);
        PacketRegistry.PacketInfo<T> packetInfo = registry.packetInfo(packetId);
        NetworkBuffer.Type<T> serializer = packetInfo.serializer();
        try {
            T packet = serializer.read(buffer);
            if (buffer.readableBytes() != 0L) {
                LOGGER.warn("WARNING: Packet ({}) 0x{} not fully read ({})", packetInfo.packetClass().getSimpleName(), Integer.toHexString(packetId), buffer);
            }
            return packet;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to read packet " + String.valueOf(packetInfo.packetClass()), e);
        }
    }

    public static int maxPacketSize(ConnectionState state) {
        return switch (state) {
            case ConnectionState.HANDSHAKE, ConnectionState.LOGIN -> ServerFlag.MAX_PACKET_SIZE_PRE_AUTH;
            default -> ServerFlag.MAX_PACKET_SIZE;
        };
    }

    public static sealed interface Result<T> {

        public record Failure<T>(long requiredCapacity) implements Result<T>
        {
        }

        public record Empty<T>() implements Result<T>
        {
        }

        public record Success<T>(List<ParsedPacket<T>> packets) implements Result<T>
        {
            public Success {
                if (packets.isEmpty()) {
                    throw new IllegalArgumentException("Empty packets");
                }
                packets = List.copyOf(packets);
            }

            public Success(ParsedPacket<T> packet) {
                this(List.of(packet));
            }
        }
    }

    public record ParsedPacket<T>(ConnectionState nextState, T packet) {
    }
}

