/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.handshake;

import net.minestom.server.Auth;
import net.minestom.server.MinecraftServer;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.client.ClientPacket;

public record ClientHandshakePacket(int protocolVersion, String serverAddress, int serverPort, Intent intent) implements ClientPacket
{
    public static final NetworkBuffer.Type<ClientHandshakePacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.VAR_INT, ClientHandshakePacket::protocolVersion, NetworkBuffer.STRING, ClientHandshakePacket::serverAddress, NetworkBuffer.UNSIGNED_SHORT, ClientHandshakePacket::serverPort, NetworkBuffer.VAR_INT.transform(Intent::fromId, Intent::id), ClientHandshakePacket::intent, ClientHandshakePacket::new);

    public ClientHandshakePacket {
        if (serverAddress.length() > ClientHandshakePacket.maxHandshakeLength()) {
            throw new IllegalArgumentException("Server address too long: " + serverAddress.length());
        }
    }

    private static int maxHandshakeLength() {
        Auth.Bungee bungee;
        Auth auth = MinecraftServer.process().auth();
        return auth instanceof Auth.Bungee ? ((bungee = (Auth.Bungee)auth).guard() ? 2500 : Short.MAX_VALUE) : 255;
    }

    public static enum Intent {
        STATUS,
        LOGIN,
        TRANSFER;


        public static Intent fromId(int id) {
            return switch (id) {
                case 1 -> STATUS;
                case 2 -> LOGIN;
                case 3 -> TRANSFER;
                default -> throw new IllegalArgumentException("Unknown connection intent: " + id);
            };
        }

        public int id() {
            return this.ordinal() + 1;
        }
    }
}

