/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Metadata;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;

public record EntityMetaDataPacket(int entityId, Map<Integer, Metadata.Entry<?>> entries) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final NetworkBuffer.Type<EntityMetaDataPacket> SERIALIZER = new NetworkBuffer.Type<EntityMetaDataPacket>(){

        @Override
        public void write(NetworkBuffer buffer, EntityMetaDataPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.entityId);
            for (Map.Entry<Integer, Metadata.Entry<?>> entry : value.entries.entrySet()) {
                buffer.write(NetworkBuffer.BYTE, entry.getKey().byteValue());
                buffer.write(Metadata.Entry.SERIALIZER, entry.getValue());
            }
            buffer.write(NetworkBuffer.BYTE, (byte)-1);
        }

        @Override
        public EntityMetaDataPacket read(NetworkBuffer buffer) {
            return new EntityMetaDataPacket(buffer.read(NetworkBuffer.VAR_INT), EntityMetaDataPacket.readEntries(buffer));
        }
    };

    public EntityMetaDataPacket {
        entries = Map.copyOf(entries);
    }

    private static Map<Integer, Metadata.Entry<?>> readEntries(NetworkBuffer reader) {
        byte index;
        HashMap entries = new HashMap();
        while ((index = reader.read(NetworkBuffer.BYTE).byteValue()) != -1) {
            Metadata.Entry<?> entry = Metadata.Entry.SERIALIZER.read(reader);
            entries.put(Integer.valueOf(index), entry);
        }
        return entries;
    }

    @Override
    public Collection<Component> components() {
        return this.entries.values().stream().map(Metadata.Entry::value).filter(entry -> entry instanceof Component).map(entry -> (Component)entry).toList();
    }

    @Override
    public ServerPacket copyWithOperator(UnaryOperator<Component> operator) {
        HashMap entries = new HashMap();
        this.entries.forEach((key, value) -> {
            int t = value.type();
            Object v = value.value();
            if (v instanceof Component) {
                Component c = (Component)v;
                Component translated = (Component)operator.apply(c);
                entries.put((Integer)key, t == Metadata.TYPE_OPT_CHAT ? Metadata.OptComponent(translated) : Metadata.Component(translated));
            } else {
                entries.put((Integer)key, (Metadata.Entry<?>)value);
            }
        });
        return new EntityMetaDataPacket(this.entityId, entries);
    }
}

