/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.UUID;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.EntityType;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;

public record SpawnEntityPacket(int entityId, UUID uuid, EntityType type, Pos position, float headRot, int data, Vec velocity) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<SpawnEntityPacket> SERIALIZER = new NetworkBuffer.Type<SpawnEntityPacket>(){

        @Override
        public void write(NetworkBuffer buffer, SpawnEntityPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.entityId);
            buffer.write(NetworkBuffer.UUID, value.uuid);
            buffer.write(EntityType.NETWORK_TYPE, value.type);
            buffer.write(NetworkBuffer.DOUBLE, value.position.x());
            buffer.write(NetworkBuffer.DOUBLE, value.position.y());
            buffer.write(NetworkBuffer.DOUBLE, value.position.z());
            buffer.write(NetworkBuffer.LP_VECTOR3, value.velocity);
            buffer.write(NetworkBuffer.BYTE, (byte)(value.position.pitch() * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.BYTE, (byte)(value.position.yaw() * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.BYTE, (byte)(value.headRot * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.VAR_INT, value.data);
        }

        @Override
        public SpawnEntityPacket read(NetworkBuffer buffer) {
            int entityId = buffer.read(NetworkBuffer.VAR_INT);
            UUID uuid = buffer.read(NetworkBuffer.UUID);
            EntityType type = buffer.read(EntityType.NETWORK_TYPE);
            double x = buffer.read(NetworkBuffer.DOUBLE);
            double y = buffer.read(NetworkBuffer.DOUBLE);
            double z = buffer.read(NetworkBuffer.DOUBLE);
            Vec velocity = buffer.read(NetworkBuffer.LP_VECTOR3);
            float pitch = (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f;
            float yaw = (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f;
            float headRot = (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f;
            int data = buffer.read(NetworkBuffer.VAR_INT);
            return new SpawnEntityPacket(entityId, uuid, type, new Pos(x, y, z, yaw, pitch), headRot, data, velocity);
        }
    };
}

