/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.component.DataComponents;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;

public record WindowItemsPacket(int windowId, int stateId, List<ItemStack> items, ItemStack carriedItem) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final int MAX_ENTRIES = 128;
    public static final NetworkBuffer.Type<WindowItemsPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.VAR_INT, WindowItemsPacket::windowId, NetworkBuffer.VAR_INT, WindowItemsPacket::stateId, ItemStack.NETWORK_TYPE.list(128), WindowItemsPacket::items, ItemStack.NETWORK_TYPE, WindowItemsPacket::carriedItem, WindowItemsPacket::new);

    public WindowItemsPacket {
        items = List.copyOf(items);
    }

    @Override
    public Collection<Component> components() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.items);
        list.add(this.carriedItem);
        ArrayList<Component> components = new ArrayList<Component>();
        list.forEach(itemStack -> {
            Component itemName;
            components.addAll(itemStack.get(DataComponents.LORE, List.of()));
            Component customName = itemStack.get(DataComponents.CUSTOM_NAME);
            if (customName != null) {
                components.add(customName);
            }
            if ((itemName = itemStack.get(DataComponents.ITEM_NAME)) != null) {
                components.add(itemName);
            }
        });
        return components;
    }

    @Override
    public ServerPacket copyWithOperator(UnaryOperator<Component> operator) {
        UnaryOperator loreOperator = lines -> {
            ArrayList translatedComponents = new ArrayList();
            lines.forEach(component -> translatedComponents.add((Component)operator.apply((Component)component)));
            return translatedComponents;
        };
        return new WindowItemsPacket(this.windowId, this.stateId, this.items.stream().map(stack -> stack.with(DataComponents.ITEM_NAME, operator).with(DataComponents.CUSTOM_NAME, operator).with(DataComponents.LORE, loreOperator)).toList(), this.carriedItem.with(DataComponents.ITEM_NAME, operator).with(DataComponents.CUSTOM_NAME, operator).with(DataComponents.LORE, loreOperator));
    }
}

