/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.player;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minestom.server.MinecraftServer;
import net.minestom.server.crypto.PlayerPublicKey;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.PlayerDisconnectEvent;
import net.minestom.server.monitoring.EventsJFR;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.common.CookieRequestPacket;
import net.minestom.server.network.packet.server.common.CookieStorePacket;
import net.minestom.server.network.packet.server.common.DisconnectPacket;
import net.minestom.server.network.packet.server.configuration.SelectKnownPacksPacket;
import net.minestom.server.network.packet.server.login.LoginDisconnectPacket;
import net.minestom.server.network.plugin.LoginPluginMessageProcessor;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerConnection {
    private Player player;
    private volatile ConnectionState serverState;
    private volatile ConnectionState clientState;
    private PlayerPublicKey playerPublicKey;
    volatile boolean online = true;
    private LoginPluginMessageProcessor loginPluginMessageProcessor = new LoginPluginMessageProcessor(this);
    private CompletableFuture<List<SelectKnownPacksPacket.Entry>> knownPacksFuture = null;
    private final Map<Key, CompletableFuture<byte @Nullable []>> pendingCookieRequests = new ConcurrentHashMap<Key, CompletableFuture<byte[]>>();

    public PlayerConnection() {
        this.serverState = ConnectionState.HANDSHAKE;
        this.clientState = ConnectionState.HANDSHAKE;
    }

    public String getIdentifier() {
        Player player = this.getPlayer();
        return player != null ? player.getUsername() : this.getRemoteAddress().toString();
    }

    public abstract void sendPacket(SendablePacket var1);

    public void sendPackets(Collection<SendablePacket> packets) {
        packets.forEach(this::sendPacket);
    }

    public void sendPackets(SendablePacket ... packets) {
        this.sendPackets(List.of(packets));
    }

    public abstract SocketAddress getRemoteAddress();

    public int getProtocolVersion() {
        return 773;
    }

    @Nullable
    public String getServerAddress() {
        return MinecraftServer.getServer().getAddress();
    }

    public int getServerPort() {
        return MinecraftServer.getServer().getPort();
    }

    public void kick(Component component) {
        Record disconnectPacket = this.serverState == ConnectionState.LOGIN ? new LoginDisconnectPacket(component) : new DisconnectPacket(component);
        this.sendPacket((SendablePacket)((Object)disconnectPacket));
        this.disconnect();
    }

    public void disconnect() {
        this.online = false;
        Player player = MinecraftServer.getConnectionManager().getPlayer(this);
        if (player != null) {
            MinecraftServer.getConnectionManager().removePlayer(this);
            if (this.serverState == ConnectionState.PLAY && !player.isRemoved()) {
                player.scheduleNextTick(Entity::remove);
            } else {
                EventDispatcher.call(new PlayerDisconnectEvent(player));
                EventsJFR.newPlayerLeave(player.getUuid()).commit();
            }
        }
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isOnline() {
        return this.online;
    }

    @Deprecated(forRemoval=true)
    public ConnectionState getConnectionState() {
        return this.getClientState();
    }

    public ConnectionState getServerState() {
        return this.serverState;
    }

    public ConnectionState getClientState() {
        return this.clientState;
    }

    public void setClientState(ConnectionState clientState) {
        if (this.clientState == ConnectionState.HANDSHAKE) {
            this.serverState = clientState;
        }
        this.clientState = clientState;
    }

    public void setServerState(ConnectionState serverState) {
        this.serverState = serverState;
        if (serverState != ConnectionState.LOGIN) {
            this.loginPluginMessageProcessor = null;
        }
    }

    public PlayerPublicKey playerPublicKey() {
        return this.playerPublicKey;
    }

    public void setPlayerPublicKey(PlayerPublicKey playerPublicKey) {
        this.playerPublicKey = playerPublicKey;
    }

    public void storeCookie(String key, byte[] data) {
        this.sendPacket(new CookieStorePacket(key, data));
    }

    public CompletableFuture<byte @Nullable []> fetchCookie(String key) {
        if (this.serverState == ConnectionState.CONFIGURATION && this.getPlayer() == null) {
            throw new IllegalStateException("Cannot fetch cookie in PlayerProvider, use AsyncPlayerPreLoginEvent or AsyncPlayerConfigurationEvent");
        }
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.pendingCookieRequests.put(Key.key(key), future);
        this.sendPacket(new CookieRequestPacket(key));
        return future;
    }

    @ApiStatus.Internal
    public void receiveCookieResponse(String key, byte @Nullable [] data) {
        CompletableFuture<byte[]> future = this.pendingCookieRequests.remove(Key.key(key));
        if (future != null) {
            future.complete(data);
        }
    }

    @ApiStatus.Internal
    public LoginPluginMessageProcessor loginPluginMessageProcessor() {
        return Objects.requireNonNull(this.loginPluginMessageProcessor, "Login plugin message processor is only available during the login state.");
    }

    @ApiStatus.Internal
    public CompletableFuture<List<SelectKnownPacksPacket.Entry>> requestKnownPacks(List<SelectKnownPacksPacket.Entry> serverPacks) {
        Check.stateCondition(this.knownPacksFuture != null, "Known packs already pending");
        this.sendPacket(new SelectKnownPacksPacket(serverPacks));
        this.knownPacksFuture = new CompletableFuture<List<SelectKnownPacksPacket.Entry>>();
        return this.knownPacksFuture;
    }

    @ApiStatus.Internal
    public void receiveKnownPacksResponse(List<SelectKnownPacksPacket.Entry> clientPacks) {
        CompletableFuture<List<SelectKnownPacksPacket.Entry>> future = this.knownPacksFuture;
        if (future != null) {
            future.complete(clientPacks);
            this.knownPacksFuture = null;
        }
    }

    public String toString() {
        return "PlayerConnection{serverState=" + String.valueOf((Object)this.serverState) + ", clientState=" + String.valueOf((Object)this.clientState) + ", identifier=" + this.getIdentifier() + "}";
    }
}

