/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.player;

import java.io.EOFException;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.zip.DataFormatException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.ListenerHandle;
import net.minestom.server.event.player.PlayerPacketOutEvent;
import net.minestom.server.extras.mojangAuth.MojangCrypt;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.PacketParser;
import net.minestom.server.network.packet.PacketReading;
import net.minestom.server.network.packet.PacketVanilla;
import net.minestom.server.network.packet.PacketWriting;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.common.ClientCookieResponsePacket;
import net.minestom.server.network.packet.client.common.ClientKeepAlivePacket;
import net.minestom.server.network.packet.client.common.ClientPingRequestPacket;
import net.minestom.server.network.packet.client.configuration.ClientFinishConfigurationPacket;
import net.minestom.server.network.packet.client.configuration.ClientSelectKnownPacksPacket;
import net.minestom.server.network.packet.client.handshake.ClientHandshakePacket;
import net.minestom.server.network.packet.client.login.ClientEncryptionResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginAcknowledgedPacket;
import net.minestom.server.network.packet.client.login.ClientLoginPluginResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginStartPacket;
import net.minestom.server.network.packet.client.status.StatusRequestPacket;
import net.minestom.server.network.packet.server.BufferedPacket;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.FramedPacket;
import net.minestom.server.network.packet.server.LazyPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.login.SetCompressionPacket;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.utils.validate.Check;
import org.jctools.queues.MpscUnboundedXaddArrayQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PlayerSocketConnection
extends PlayerConnection {
    private static final Set<Class<? extends ClientPacket>> IMMEDIATE_PROCESS_PACKETS = Set.of(ClientHandshakePacket.class, ClientCookieResponsePacket.class, StatusRequestPacket.class, ClientPingRequestPacket.class, ClientKeepAlivePacket.class, ClientLoginStartPacket.class, ClientEncryptionResponsePacket.class, ClientLoginPluginResponsePacket.class, ClientSelectKnownPacksPacket.class, ClientLoginAcknowledgedPacket.class, ClientFinishConfigurationPacket.class);
    private final SocketChannel channel;
    private SocketAddress remoteAddress;
    private volatile EncryptionContext encryptionContext;
    private byte[] nonce = new byte[4];
    private String loginUsername;
    private GameProfile gameProfile;
    private String serverAddress;
    private int serverPort;
    private int protocolVersion;
    private final NetworkBuffer readBuffer = NetworkBuffer.resizableBuffer(ServerFlag.POOLED_BUFFER_SIZE, MinecraftServer.process());
    private final MpscUnboundedXaddArrayQueue<SendablePacket> packetQueue = new MpscUnboundedXaddArrayQueue(1024);
    private final Thread readThread;
    private final Thread writeThread;
    private final AtomicLong sentPacketCounter = new AtomicLong();
    private volatile long compressionStart = Long.MAX_VALUE;
    private final AtomicBoolean writeSignaled = new AtomicBoolean(false);
    private final ListenerHandle<PlayerPacketOutEvent> outgoing = EventDispatcher.getHandle(PlayerPacketOutEvent.class);
    private NetworkBuffer writeLeftover = null;

    public PlayerSocketConnection(SocketChannel channel, SocketAddress remoteAddress, Thread readThread, Thread writeThread) {
        this.channel = channel;
        this.remoteAddress = remoteAddress;
        this.writeThread = writeThread;
        this.readThread = readThread;
    }

    public void read(PacketParser<ClientPacket> packetParser) throws IOException {
        NetworkBuffer readBuffer = this.readBuffer;
        long writeIndex = readBuffer.writeIndex();
        int length = readBuffer.readChannel(this.channel);
        EncryptionContext encryptionContext = this.encryptionContext;
        if (encryptionContext != null) {
            readBuffer.cipher(encryptionContext.decrypt(), writeIndex, length);
        }
        this.processPackets(readBuffer, packetParser);
    }

    private boolean compression() {
        return this.compressionStart != Long.MAX_VALUE;
    }

    private void processPackets(NetworkBuffer readBuffer, PacketParser<ClientPacket> packetParser) {
        PacketReading.Result<ClientPacket> result;
        ConnectionState startingState = this.getClientState();
        try {
            result = PacketReading.readPackets(readBuffer, packetParser, startingState, PacketVanilla::nextClientState, this.compression());
        }
        catch (DataFormatException e) {
            MinecraftServer.getExceptionManager().handleException(e);
            this.disconnect();
            return;
        }
        PacketReading.Result<ClientPacket> result2 = result;
        Objects.requireNonNull(result2);
        PacketReading.Result<ClientPacket> result3 = result2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PacketReading.Result.Success.class, PacketReading.Result.Empty.class, PacketReading.Result.Failure.class}, result3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PacketReading.Result.Success success = (PacketReading.Result.Success)result3;
                for (PacketReading.ParsedPacket parsedPacket : success.packets()) {
                    ClientPacket packet = (ClientPacket)parsedPacket.packet();
                    try {
                        boolean processImmediately = IMMEDIATE_PROCESS_PACKETS.contains(packet.getClass());
                        if (processImmediately) {
                            MinecraftServer.getPacketListenerManager().processClientPacket(packet, this);
                            continue;
                        }
                        Player player = this.getPlayer();
                        assert (player != null);
                        player.addPacketToQueue(packet);
                    }
                    catch (Exception e) {
                        MinecraftServer.getExceptionManager().handleException(e);
                    }
                }
                readBuffer.compact();
                break;
            }
            case 1: {
                PacketReading.Result.Empty ignored = (PacketReading.Result.Empty)result3;
                break;
            }
            case 2: {
                PacketReading.Result.Failure failure = (PacketReading.Result.Failure)result3;
                long requiredCapacity = failure.requiredCapacity();
                assert (requiredCapacity > readBuffer.capacity()) : "New capacity should be greater than the current one: " + requiredCapacity + " <= " + readBuffer.capacity();
                readBuffer.resize(requiredCapacity);
            }
        }
    }

    public void setEncryptionKey(SecretKey secretKey) {
        Check.stateCondition(this.encryptionContext != null, "Encryption is already enabled!");
        this.encryptionContext = new EncryptionContext(MojangCrypt.getCipher(1, secretKey), MojangCrypt.getCipher(2, secretKey));
    }

    public void startCompression() {
        Check.stateCondition(this.compression(), "Compression is already enabled!");
        this.compressionStart = this.sentPacketCounter.get();
        int threshold = MinecraftServer.getCompressionThreshold();
        Check.stateCondition(threshold == 0, "Compression cannot be enabled because the threshold is equal to 0");
        this.sendPacket(new SetCompressionPacket(threshold));
    }

    @Override
    public void sendPacket(SendablePacket packet) {
        this.packetQueue.relaxedOffer((Object)packet);
        this.unlockWriteThread();
    }

    @Override
    public void sendPackets(Collection<SendablePacket> packets) {
        for (SendablePacket packet : packets) {
            this.packetQueue.relaxedOffer((Object)packet);
        }
        this.unlockWriteThread();
    }

    private void unlockWriteThread() {
        if (!ServerFlag.FASTER_SOCKET_WRITES) {
            return;
        }
        if (!this.writeSignaled.compareAndExchange(false, true)) {
            LockSupport.unpark(this.writeThread);
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @ApiStatus.Internal
    public void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    @Nullable
    public GameProfile gameProfile() {
        return this.gameProfile;
    }

    public void UNSAFE_setProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    @Nullable
    public String getLoginUsername() {
        return this.loginUsername;
    }

    public void UNSAFE_setLoginUsername(String loginUsername) {
        this.loginUsername = loginUsername;
    }

    @Override
    @Nullable
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void refreshServerInformation(@Nullable String serverAddress, int serverPort, int protocolVersion) {
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.protocolVersion = protocolVersion;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    private boolean writeSendable(NetworkBuffer buffer, SendablePacket sendable, boolean compressed) {
        long start = buffer.writeIndex();
        boolean result = this.writePacketSync(buffer, sendable, compressed);
        if (!result) {
            return false;
        }
        long length = buffer.writeIndex() - start;
        EncryptionContext encryptionContext = this.encryptionContext;
        if (encryptionContext != null && length > 0L) {
            buffer.cipher(encryptionContext.encrypt(), start, length);
        }
        return true;
    }

    private boolean writePacketSync(NetworkBuffer buffer, SendablePacket packet, boolean compressed) {
        Player player = this.getPlayer();
        ConnectionState state = this.getServerState();
        if (player != null) {
            ServerPacket serverPacket;
            if (this.outgoing.hasListener() && (serverPacket = SendablePacket.extractServerPacket(state, packet)) != null) {
                PlayerPacketOutEvent event = new PlayerPacketOutEvent(player, serverPacket);
                this.outgoing.call(event);
                if (event.isCancelled()) {
                    return true;
                }
            }
            if (MinestomAdventure.AUTOMATIC_COMPONENT_TRANSLATION && packet instanceof ServerPacket.ComponentHolding) {
                packet = (SendablePacket)((ServerPacket.ComponentHolding)((Object)packet)).copyWithOperator(component -> MinestomAdventure.COMPONENT_TRANSLATOR.apply((Component)component, Objects.requireNonNullElseGet(player.getLocale(), MinestomAdventure::getDefaultLocale)));
            }
        }
        long start = buffer.writeIndex();
        int compressionThreshold = compressed ? MinecraftServer.getCompressionThreshold() : 0;
        try {
            SendablePacket sendablePacket = packet;
            Objects.requireNonNull(sendablePacket);
            SendablePacket sendablePacket2 = sendablePacket;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ServerPacket.class, FramedPacket.class, CachedPacket.class, LazyPacket.class, BufferedPacket.class}, (SendablePacket)sendablePacket2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ServerPacket serverPacket = (ServerPacket)sendablePacket2;
                    ConnectionState nextState = PacketVanilla.nextServerState(serverPacket, state);
                    if (nextState != state) {
                        this.setServerState(nextState);
                    }
                    PacketWriting.writeFramedPacket(buffer, state, serverPacket, compressionThreshold);
                    yield true;
                }
                case 1 -> {
                    FramedPacket framedPacket = (FramedPacket)sendablePacket2;
                    NetworkBuffer body = framedPacket.body();
                    yield this.writeBuffer(buffer, body, 0L, body.capacity());
                }
                case 2 -> {
                    CachedPacket cachedPacket = (CachedPacket)sendablePacket2;
                    NetworkBuffer body = cachedPacket.body(state);
                    if (body != null) {
                        yield this.writeBuffer(buffer, body, 0L, body.capacity());
                    }
                    PacketWriting.writeFramedPacket(buffer, state, cachedPacket.packet(state), compressionThreshold);
                    yield true;
                }
                case 3 -> {
                    LazyPacket lazyPacket = (LazyPacket)sendablePacket2;
                    PacketWriting.writeFramedPacket(buffer, state, lazyPacket.packet(), compressionThreshold);
                    yield true;
                }
                case 4 -> {
                    BufferedPacket bufferedPacket = (BufferedPacket)sendablePacket2;
                    NetworkBuffer rawBuffer = bufferedPacket.buffer();
                    long index = bufferedPacket.index();
                    long length = bufferedPacket.length();
                    yield this.writeBuffer(buffer, rawBuffer, index, length);
                }
            };
        }
        catch (IndexOutOfBoundsException exception) {
            buffer.writeIndex(start);
            return false;
        }
    }

    private boolean writeBuffer(NetworkBuffer buffer, NetworkBuffer body, long index, long length) {
        if (buffer.writableBytes() < length) {
            return false;
        }
        NetworkBuffer.copy(body, index, buffer, buffer.writeIndex(), length);
        buffer.advanceWrite(length);
        return true;
    }

    public void flushSync() throws IOException {
        MpscUnboundedXaddArrayQueue<SendablePacket> packetQueue;
        NetworkBuffer leftover = this.writeLeftover;
        if (leftover != null) {
            boolean success = leftover.writeChannel(this.channel);
            if (success) {
                this.writeLeftover = null;
                PacketVanilla.PACKET_POOL.add(leftover);
            } else {
                return;
            }
        }
        if ((packetQueue = this.packetQueue).isEmpty()) {
            if (!ServerFlag.FASTER_SOCKET_WRITES) {
                try {
                    Thread.sleep(1000 / ServerFlag.SERVER_TICKS_PER_SECOND / 2);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } else {
                assert (this.writeThread == Thread.currentThread()) : "writeThread should be the current thread";
                this.writeSignaled.set(false);
                LockSupport.park(this);
                assert (this.packetQueue.peek() != null) : "packet queue should not be empty";
            }
        }
        if (!this.channel.isConnected()) {
            throw new EOFException("Channel is closed");
        }
        NetworkBuffer buffer = PacketVanilla.PACKET_POOL.get();
        PacketWriting.writeQueue(buffer, packetQueue, 1, (b, packet) -> {
            boolean compressed = this.sentPacketCounter.get() > this.compressionStart;
            boolean success = this.writeSendable((NetworkBuffer)b, (SendablePacket)packet, compressed);
            if (success) {
                this.sentPacketCounter.getAndIncrement();
            }
            return success;
        });
        boolean success = buffer.writeChannel(this.channel);
        if (success) {
            PacketVanilla.PACKET_POOL.add(buffer);
        } else {
            this.writeLeftover = buffer;
        }
    }

    public Thread readThread() {
        return this.readThread;
    }

    public Thread writeThread() {
        return this.writeThread;
    }

    record EncryptionContext(Cipher encrypt, Cipher decrypt) {
    }
}

