/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.socket;

import java.io.EOFException;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.network.packet.PacketParser;
import net.minestom.server.network.packet.PacketVanilla;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;

public final class Server {
    private volatile boolean stop;
    private final PacketParser<ClientPacket> packetParser;
    private ServerSocketChannel serverSocket;
    private SocketAddress socketAddress;
    private String address;
    private int port;

    public Server(PacketParser<ClientPacket> packetParser) {
        this.packetParser = packetParser;
    }

    public Server() {
        this(PacketVanilla.CLIENT_PACKET_PARSER);
    }

    @ApiStatus.Internal
    public void init(SocketAddress address) throws IOException {
        SocketAddress socketAddress = address;
        Objects.requireNonNull(socketAddress);
        SocketAddress socketAddress2 = socketAddress;
        int n = 0;
        ServerSocketChannel server = ServerSocketChannel.open(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InetSocketAddress.class, UnixDomainSocketAddress.class}, (SocketAddress)socketAddress2, n)) {
            case 0 -> {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress2;
                this.address = inetSocketAddress.getHostString();
                this.port = inetSocketAddress.getPort();
                yield inetSocketAddress.getAddress().getAddress().length == 4 ? StandardProtocolFamily.INET : StandardProtocolFamily.INET6;
            }
            case 1 -> {
                UnixDomainSocketAddress unixDomainSocketAddress = (UnixDomainSocketAddress)socketAddress2;
                this.address = "unix://" + String.valueOf(unixDomainSocketAddress.getPath());
                this.port = 0;
                yield StandardProtocolFamily.UNIX;
            }
            default -> throw new IllegalArgumentException("Address must be an InetSocketAddress or a UnixDomainSocketAddress");
        });
        server.bind(address);
        this.serverSocket = server;
        this.socketAddress = address;
        if (address instanceof InetSocketAddress && this.port == 0) {
            this.port = server.socket().getLocalPort();
        }
    }

    @ApiStatus.Internal
    public void start() {
        Thread.Builder.OfVirtual readBuilder = Thread.ofVirtual().name("Ms-Socket-Reader-", 0L);
        Thread.Builder.OfVirtual writeBuilder = Thread.ofVirtual().name("Ms-Socket-Writer-", 0L);
        Thread.ofVirtual().name("Ms-Socket-Server").start(() -> {
            while (!this.stop) {
                try {
                    SocketChannel client = this.serverSocket.accept();
                    this.configureSocket(client);
                    AtomicReference<Object> reference = new AtomicReference<Object>(null);
                    Thread readThread = readBuilder.unstarted(() -> this.playerReadLoop((PlayerSocketConnection)reference.get()));
                    Thread writeThread = writeBuilder.unstarted(() -> this.playerWriteLoop((PlayerSocketConnection)reference.get()));
                    PlayerSocketConnection connection = new PlayerSocketConnection(client, client.getRemoteAddress(), readThread, writeThread);
                    reference.set(connection);
                    readThread.start();
                    writeThread.start();
                }
                catch (AsynchronousCloseException client) {
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void configureSocket(SocketChannel channel) throws IOException {
        if (channel.getLocalAddress() instanceof InetSocketAddress) {
            Socket socket = channel.socket();
            socket.setSendBufferSize(ServerFlag.SOCKET_SEND_BUFFER_SIZE);
            socket.setReceiveBufferSize(ServerFlag.SOCKET_RECEIVE_BUFFER_SIZE);
            socket.setTcpNoDelay(ServerFlag.SOCKET_NO_DELAY);
            socket.setSoTimeout(ServerFlag.SOCKET_TIMEOUT);
        }
    }

    private void playerReadLoop(PlayerSocketConnection connection) {
        Check.notNull(connection, "connection cannot be null");
        while (!this.stop) {
            try {
                connection.read(this.packetParser);
            }
            catch (ClosedChannelException ignored) {
                break;
            }
            catch (EOFException e) {
                connection.disconnect();
                break;
            }
            catch (Throwable e) {
                boolean isExpected;
                boolean bl = isExpected = e instanceof SocketException && e.getMessage().equals("Connection reset");
                if (!isExpected) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
                connection.disconnect();
                break;
            }
        }
    }

    private void playerWriteLoop(PlayerSocketConnection connection) {
        Check.notNull(connection, "connection cannot be null");
        while (!this.stop) {
            try {
                connection.flushSync();
            }
            catch (ClosedChannelException ignored) {
                break;
            }
            catch (EOFException e) {
                connection.disconnect();
                break;
            }
            catch (Throwable e) {
                boolean isExpected;
                boolean bl = isExpected = e instanceof IOException && e.getMessage().equals("Broken pipe");
                if (!isExpected) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
                connection.disconnect();
                break;
            }
            if (connection.isOnline()) continue;
            try {
                connection.flushSync();
                connection.getChannel().close();
            }
            catch (IOException e) {}
            break;
        }
    }

    public boolean isOpen() {
        return !this.stop;
    }

    public void stop() {
        this.stop = true;
        try {
            SocketAddress socketAddress;
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            if ((socketAddress = this.socketAddress) instanceof UnixDomainSocketAddress) {
                UnixDomainSocketAddress unixDomainSocketAddress = (UnixDomainSocketAddress)socketAddress;
                Files.deleteIfExists(unixDomainSocketAddress.getPath());
            }
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
    }

    @ApiStatus.Internal
    public PacketParser<ClientPacket> packetParser() {
        return this.packetParser;
    }

    public SocketAddress socketAddress() {
        return this.socketAddress;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }
}

