/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.particle;

import java.util.Collection;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.kyori.adventure.util.RGBLike;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.color.AlphaColor;
import net.minestom.server.color.Color;
import net.minestom.server.coordinate.Point;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.particle.ParticleImpl;
import net.minestom.server.particle.Particles;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public sealed interface Particle
extends StaticProtocolObject<Particle>,
Particles {
    public static final NetworkBuffer.Type<Particle> NETWORK_TYPE = new NetworkBuffer.Type<Particle>(){

        @Override
        public void write(NetworkBuffer buffer, Particle value) {
            buffer.write(NetworkBuffer.VAR_INT, value.id());
            value.writeData(buffer);
        }

        @Override
        public Particle read(NetworkBuffer buffer) {
            int id = buffer.read(NetworkBuffer.VAR_INT);
            Particle particle = Objects.requireNonNull(Particle.fromId(id), () -> "unknown particle id: " + id);
            return particle.readData(buffer);
        }
    };
    public static final Codec<Particle> CODEC = new Codec<Particle>(){

        @Override
        public <D> Result<Particle> decode(Transcoder<D> coder, D value) {
            return new Result.Error<Particle>("particles cannot be decoded");
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder, @Nullable Particle value) {
            if (value == null) {
                return new Result.Error("null");
            }
            return value.encode(coder);
        }
    };

    public static Collection<Particle> values() {
        return ParticleImpl.REGISTRY.values();
    }

    @Nullable
    public static Particle fromKey(@KeyPattern String key) {
        return Particle.fromKey(Key.key(key));
    }

    @Nullable
    public static Particle fromKey(Key key) {
        return ParticleImpl.REGISTRY.get(key);
    }

    @Nullable
    public static Particle fromId(int id) {
        return ParticleImpl.REGISTRY.get(id);
    }

    public Particle readData(NetworkBuffer var1);

    public void writeData(NetworkBuffer var1);

    public <D> Result<D> encode(Transcoder<D> var1);

    public record InstantEffect(Key key, int id, RGBLike color, float power) implements Particle
    {
        @Contract(pure=true)
        public InstantEffect withColor(RGBLike color) {
            return new InstantEffect(this.key(), this.id(), color, this.power);
        }

        @Contract(pure=true)
        public InstantEffect withPower(float power) {
            return new InstantEffect(this.key(), this.id(), this.color, power);
        }

        @Contract(pure=true)
        public InstantEffect withProperties(RGBLike color, float power) {
            return new InstantEffect(this.key(), this.id(), color, power);
        }

        @Override
        public InstantEffect readData(NetworkBuffer reader) {
            return this.withProperties(reader.read(Color.NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(Color.NETWORK_TYPE, this.color);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.power));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            Object colorData;
            Result<D> colorResult = Color.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t;
                colorData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("color", colorData).put("power", coder.createFloat(this.power)).build());
        }
    }

    public record Flash(Key key, int id, AlphaColor color) implements Particle
    {
        @Contract(pure=true)
        public Flash withColor(AlphaColor color) {
            return new Flash(this.key(), this.id(), color);
        }

        @Contract(pure=true)
        public Flash withColor(RGBLike color) {
            return new Flash(this.key(), this.id(), new AlphaColor(1, color));
        }

        @Contract(pure=true)
        public Flash withColor(int alpha, RGBLike color) {
            return new Flash(this.key(), this.id(), new AlphaColor(alpha, color));
        }

        @Override
        public Flash readData(NetworkBuffer reader) {
            return this.withColor(reader.read(AlphaColor.NETWORK_TYPE));
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(AlphaColor.NETWORK_TYPE, this.color);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            Object colorData;
            Result<D> colorResult = AlphaColor.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t;
                colorData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("color", colorData).build());
        }
    }

    public record Effect(Key key, int id, RGBLike color, float power) implements Particle
    {
        @Contract(pure=true)
        public Effect withColor(RGBLike color) {
            return new Effect(this.key(), this.id(), color, this.power);
        }

        @Contract(pure=true)
        public Effect withPower(float power) {
            return new Effect(this.key(), this.id(), this.color, power);
        }

        @Contract(pure=true)
        public Effect withProperties(RGBLike color, float power) {
            return new Effect(this.key(), this.id(), color, power);
        }

        @Override
        public Effect readData(NetworkBuffer reader) {
            return this.withProperties(reader.read(Color.NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(Color.NETWORK_TYPE, this.color);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.power));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            Object colorData;
            Result<D> colorResult = Color.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t;
                colorData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("color", colorData).put("power", coder.createFloat(this.power)).build());
        }
    }

    public record DragonBreath(Key key, int id, float power) implements Particle
    {
        @Contract(pure=true)
        public DragonBreath withPower(float power) {
            return new DragonBreath(this.key(), this.id(), power);
        }

        @Override
        public DragonBreath readData(NetworkBuffer reader) {
            return this.withPower(reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.power));
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("power", coder.createFloat(this.power)).build());
        }
    }

    public record TintedLeaves(Key key, int id, AlphaColor color) implements Particle
    {
        @Contract(pure=true)
        public TintedLeaves withColor(AlphaColor color) {
            return new TintedLeaves(this.key(), this.id(), color);
        }

        @Contract(pure=true)
        public TintedLeaves withColor(RGBLike color) {
            return new TintedLeaves(this.key(), this.id(), new AlphaColor(1, color));
        }

        @Contract(pure=true)
        public TintedLeaves withColor(int alpha, RGBLike color) {
            return new TintedLeaves(this.key(), this.id(), new AlphaColor(alpha, color));
        }

        @Override
        public TintedLeaves readData(NetworkBuffer reader) {
            return this.withColor(reader.read(AlphaColor.NETWORK_TYPE));
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(AlphaColor.NETWORK_TYPE, this.color);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            Object colorData;
            Result<D> colorResult = AlphaColor.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t;
                colorData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("color", colorData).build());
        }
    }

    public record BlockCrumble(Key key, int id, net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        public Block withBlock(net.minestom.server.instance.block.Block block) {
            return new Block(this.key(), this.id(), block);
        }

        @Override
        public Block readData(NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("block_state", coder.createString(this.block.state())).build());
        }
    }

    public record Trail(Key key, int id, Point target, RGBLike color, int duration) implements Particle
    {
        public Trail withProperties(Point target, RGBLike color, int duration) {
            return new Trail(this.key(), this.id(), target, color, duration);
        }

        public Trail withTarget(Point target) {
            return new Trail(this.key(), this.id(), target, this.color, this.duration);
        }

        public Trail withColor(RGBLike color) {
            return new Trail(this.key(), this.id(), this.target, color, this.duration);
        }

        public Trail withDuration(int duration) {
            return new Trail(this.key(), this.id(), this.target, this.color, duration);
        }

        @Override
        public Trail readData(NetworkBuffer reader) {
            return this.withProperties(reader.read(NetworkBuffer.VECTOR3D), reader.read(Color.NETWORK_TYPE), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(NetworkBuffer.VECTOR3D, this.target);
            writer.write(Color.NETWORK_TYPE, this.color);
            writer.write(NetworkBuffer.VAR_INT, this.duration);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            Object t;
            Object colorData;
            Result<D> colorResult = Color.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t2;
                colorData = t2 = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Result<D> targetResult = Codec.VECTOR3D.encode(coder, this.target);
            if (!(targetResult instanceof Result.Ok)) return targetResult.cast();
            ok = (Result.Ok)targetResult;
            Object targetData = t = ok.value();
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("target", targetData).put("color", colorData).build());
        }
    }

    public record Vibration(Key key, int id, SourceType sourceType, @Nullable Point sourceBlockPosition, int sourceEntityId, float sourceEntityEyeHeight, int travelTicks) implements Particle
    {
        @Contract(pure=true)
        public Vibration withProperties(SourceType sourceType, @Nullable Point sourceBlockPosition, int sourceEntityId, float sourceEntityEyeHeight, int travelTicks) {
            return new Vibration(this.key(), this.id(), sourceType, sourceBlockPosition, sourceEntityId, sourceEntityEyeHeight, travelTicks);
        }

        @Contract(pure=true)
        public Vibration withSourceBlockPosition(@Nullable Point sourceBlockPosition, int travelTicks) {
            return new Vibration(this.key(), this.id(), SourceType.BLOCK, sourceBlockPosition, this.sourceEntityId, this.sourceEntityEyeHeight, travelTicks);
        }

        @Contract(pure=true)
        public Vibration withSourceEntity(int sourceEntityId, float sourceEntityEyeHeight, int travelTicks) {
            return new Vibration(this.key(), this.id(), SourceType.ENTITY, this.sourceBlockPosition, sourceEntityId, sourceEntityEyeHeight, travelTicks);
        }

        @Override
        public Vibration readData(NetworkBuffer reader) {
            SourceType type = reader.read(NetworkBuffer.Enum(SourceType.class));
            if (type == SourceType.BLOCK) {
                return this.withSourceBlockPosition(reader.read(NetworkBuffer.BLOCK_POSITION), reader.read(NetworkBuffer.VAR_INT));
            }
            return this.withSourceEntity(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(NetworkBuffer.Enum(SourceType.class), this.sourceType);
            if (this.sourceType == SourceType.BLOCK) {
                Objects.requireNonNull(this.sourceBlockPosition);
                writer.write(NetworkBuffer.BLOCK_POSITION, this.sourceBlockPosition);
                writer.write(NetworkBuffer.VAR_INT, this.travelTicks);
            } else {
                writer.write(NetworkBuffer.VAR_INT, this.sourceEntityId);
                writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.sourceEntityEyeHeight));
                writer.write(NetworkBuffer.VAR_INT, this.travelTicks);
            }
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            return new Result.Error("Vibration particle cannot be serialized to NBT");
        }

        public static enum SourceType {
            BLOCK,
            ENTITY;

        }
    }

    public record Shriek(Key key, int id, int delay) implements Particle
    {
        @Contract(pure=true)
        public Shriek withDelay(int delay) {
            return new Shriek(this.key(), this.id(), delay);
        }

        @Override
        public Shriek readData(NetworkBuffer reader) {
            return this.withDelay(reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.delay);
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("delay", coder.createInt(this.delay)).build());
        }
    }

    public record SculkCharge(Key key, int id, float roll) implements Particle
    {
        @Contract(pure=true)
        public SculkCharge withRoll(float roll) {
            return new SculkCharge(this.key(), this.id(), roll);
        }

        @Override
        public SculkCharge readData(NetworkBuffer reader) {
            return this.withRoll(reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.roll));
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("roll", coder.createFloat(this.roll)).build());
        }
    }

    public record EntityEffect(Key key, int id, AlphaColor color) implements Particle
    {
        @Contract(pure=true)
        public EntityEffect withColor(AlphaColor color) {
            return new EntityEffect(this.key(), this.id(), color);
        }

        @Contract(pure=true)
        public EntityEffect withColor(RGBLike color) {
            return new EntityEffect(this.key(), this.id(), new AlphaColor(1, color));
        }

        @Contract(pure=true)
        public EntityEffect withColor(int alpha, RGBLike color) {
            return new EntityEffect(this.key(), this.id(), new AlphaColor(alpha, color));
        }

        @Override
        public EntityEffect readData(NetworkBuffer reader) {
            return this.withColor(reader.read(AlphaColor.NETWORK_TYPE));
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(AlphaColor.NETWORK_TYPE, this.color);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            Object colorData;
            Result<D> colorResult = AlphaColor.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t;
                colorData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("color", colorData).build());
        }
    }

    public record Item(Key key, int id, ItemStack item) implements Particle
    {
        @Contract(pure=true)
        public Item withItem(ItemStack item) {
            return new Item(this.key(), this.id(), item);
        }

        @Override
        public Item readData(NetworkBuffer reader) {
            return this.withItem(reader.read(ItemStack.NETWORK_TYPE));
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(ItemStack.NETWORK_TYPE, this.item);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            Object itemData;
            Result<D> itemResult = ItemStack.CODEC.encode(coder, this.item);
            if (!(itemResult instanceof Result.Ok)) return itemResult.cast();
            Result.Ok ok = (Result.Ok)itemResult;
            try {
                Object t;
                itemData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("item", itemData).build());
        }
    }

    public record FallingDust(Key key, int id, net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        public FallingDust withBlock(net.minestom.server.instance.block.Block block) {
            return new FallingDust(this.key(), this.id(), block);
        }

        @Override
        public FallingDust readData(NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("block_state", coder.createString(this.block.state())).build());
        }
    }

    public record DustPillar(Key key, int id, net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        public DustPillar withBlock(net.minestom.server.instance.block.Block block) {
            return new DustPillar(this.key(), this.id(), block);
        }

        @Override
        public DustPillar readData(NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("block_state", coder.createString(this.block.state())).build());
        }
    }

    public record DustColorTransition(Key key, int id, RGBLike color, RGBLike transitionColor, float scale) implements Particle
    {
        @Contract(pure=true)
        public DustColorTransition withProperties(RGBLike color, RGBLike transitionColor, float scale) {
            return new DustColorTransition(this.key, this.id, color, transitionColor, scale);
        }

        @Contract(pure=true)
        public DustColorTransition withColor(RGBLike color) {
            return this.withProperties(color, this.transitionColor, this.scale);
        }

        @Contract(pure=true)
        public DustColorTransition withScale(float scale) {
            return this.withProperties(this.color, this.transitionColor, scale);
        }

        @Contract(pure=true)
        public DustColorTransition withTransitionColor(RGBLike transitionColor) {
            return this.withProperties(this.color, transitionColor, this.scale);
        }

        @Override
        public DustColorTransition readData(NetworkBuffer reader) {
            return this.withProperties(reader.read(Color.NETWORK_TYPE), reader.read(Color.NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(Color.NETWORK_TYPE, this.color);
            writer.write(Color.NETWORK_TYPE, this.transitionColor);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.scale));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            Object t;
            Object fromColorData;
            Result<D> fromColorResult = Color.CODEC.encode(coder, this.color);
            if (!(fromColorResult instanceof Result.Ok)) return fromColorResult.cast();
            Result.Ok ok = (Result.Ok)fromColorResult;
            try {
                Object t2;
                fromColorData = t2 = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Result<D> toColorResult = Color.CODEC.encode(coder, this.transitionColor);
            if (!(toColorResult instanceof Result.Ok)) return toColorResult.cast();
            ok = (Result.Ok)toColorResult;
            Object toColorData = t = ok.value();
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("from_color", fromColorData).put("to_color", toColorData).put("scale", coder.createFloat(this.scale)).build());
        }
    }

    public record Dust(Key key, int id, RGBLike color, float scale) implements Particle
    {
        @Contract(pure=true)
        public Dust withProperties(RGBLike color, float scale) {
            return new Dust(this.key(), this.id(), color, scale);
        }

        @Contract(pure=true)
        public Dust withColor(RGBLike color) {
            return this.withProperties(color, this.scale);
        }

        @Contract(pure=true)
        public Dust withScale(float scale) {
            return this.withProperties(this.color, scale);
        }

        @Override
        public Dust readData(NetworkBuffer reader) {
            return this.withProperties(reader.read(Color.NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(Color.NETWORK_TYPE, this.color);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.scale));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            Object colorData;
            Result<D> colorResult = Color.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t;
                colorData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("color", colorData).put("scale", coder.createFloat(this.scale)).build());
        }
    }

    public record BlockMarker(Key key, int id, net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        public BlockMarker withBlock(net.minestom.server.instance.block.Block block) {
            return new BlockMarker(this.key(), this.id(), block);
        }

        @Override
        public BlockMarker readData(NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("block_state", coder.createString(this.block.state())).build());
        }
    }

    public record Block(Key key, int id, net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        public Block withBlock(net.minestom.server.instance.block.Block block) {
            return new Block(this.key(), this.id(), block);
        }

        @Override
        public Block readData(NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("block_state", coder.createString(this.block.state())).build());
        }
    }

    public record Simple(Key key, int id) implements Particle
    {
        @Override
        public Particle readData(NetworkBuffer reader) {
            return this;
        }

        @Override
        public void writeData(NetworkBuffer writer) {
        }

        @Override
        public <D> Result<D> encode(Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).build());
        }
    }
}

