/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.potion;

import java.util.Objects;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.potion.PotionEffect;
import org.jetbrains.annotations.Nullable;

public record CustomPotionEffect(PotionEffect id, Settings settings) {
    public static final NetworkBuffer.Type<CustomPotionEffect> NETWORK_TYPE = NetworkBufferTemplate.template(PotionEffect.NETWORK_TYPE, CustomPotionEffect::id, Settings.NETWORK_TYPE, CustomPotionEffect::settings, CustomPotionEffect::new);
    public static final Codec<CustomPotionEffect> CODEC = StructCodec.struct("id", PotionEffect.CODEC, CustomPotionEffect::id, "$$inline$$", Settings.CODEC, CustomPotionEffect::settings, CustomPotionEffect::new);

    public CustomPotionEffect(PotionEffect id, int amplifier, int duration, boolean isAmbient, boolean showParticles, boolean showIcon) {
        this(id, new Settings(amplifier, duration, isAmbient, showParticles, showIcon, null));
    }

    public int amplifier() {
        return this.settings.amplifier;
    }

    public int duration() {
        return this.settings.duration;
    }

    public boolean isAmbient() {
        return this.settings.isAmbient;
    }

    public boolean showParticles() {
        return this.settings.showParticles;
    }

    public boolean showIcon() {
        return this.settings.showIcon;
    }

    public record Settings(int amplifier, int duration, boolean isAmbient, boolean showParticles, boolean showIcon, @Nullable Settings hiddenEffect) {
        public static final NetworkBuffer.Type<Settings> NETWORK_TYPE = new NetworkBuffer.Type<Settings>(){

            @Override
            public void write(NetworkBuffer buffer, Settings value) {
                buffer.write(NetworkBuffer.VAR_INT, value.amplifier);
                buffer.write(NetworkBuffer.VAR_INT, value.duration);
                buffer.write(NetworkBuffer.BOOLEAN, value.isAmbient);
                buffer.write(NetworkBuffer.BOOLEAN, value.showParticles);
                buffer.write(NetworkBuffer.BOOLEAN, value.showIcon);
                buffer.write(NETWORK_TYPE.optional(), value.hiddenEffect);
            }

            @Override
            public Settings read(NetworkBuffer buffer) {
                return new Settings(buffer.read(NetworkBuffer.VAR_INT), buffer.read(NetworkBuffer.VAR_INT), buffer.read(NetworkBuffer.BOOLEAN), buffer.read(NetworkBuffer.BOOLEAN), buffer.read(NetworkBuffer.BOOLEAN), buffer.read(NETWORK_TYPE.optional()));
            }
        };
        public static final Codec<Settings> CODEC = Codec.Recursive(self -> StructCodec.struct("amplifier", Codec.BYTE.optional((byte)0), s -> (byte)s.amplifier, "duration", Codec.INT.optional(0), Settings::duration, "ambient", Codec.BOOLEAN.optional(false), Settings::isAmbient, "show_particles", Codec.BOOLEAN.optional(true), Settings::showParticles, "show_icon", Codec.BOOLEAN.optional(), Settings::showIcon, "hidden_effect", self.optional(), Settings::hiddenEffect, Settings::withOptionalIcon));

        private static Settings withOptionalIcon(byte amplifier, int duration, boolean isAmbient, boolean showParticles, @Nullable Boolean showIcon, @Nullable Settings hiddenEffect) {
            return new Settings(amplifier, duration, isAmbient, showParticles, Objects.requireNonNullElse(showIcon, showParticles), hiddenEffect);
        }
    }
}

