/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe.display;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;

public enum RecipeDisplayType implements StaticProtocolObject<RecipeDisplayType>
{
    CRAFTING_SHAPELESS("crafting_shapeless"),
    CRAFTING_SHAPED("crafting_shaped"),
    FURNACE("furnace"),
    STONECUTTER("stonecutter"),
    SMITHING("smithing");

    private static final Map<Key, RecipeDisplayType> BY_KEY;
    public static final NetworkBuffer.Type<RecipeDisplayType> NETWORK_TYPE;
    public static final Codec<RecipeDisplayType> CODEC;
    private final Key key;

    private RecipeDisplayType(String key) {
        this.key = Key.key(key);
    }

    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(RecipeDisplayType.values()).collect(Collectors.toUnmodifiableMap(RecipeDisplayType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(RecipeDisplayType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, RecipeDisplayType::key);
    }
}

