/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.dialog.Dialog;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.registry.DynamicRegistryImpl;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public sealed interface DynamicRegistry<T>
extends Registry<T>
permits DynamicRegistryImpl {
    @SafeVarargs
    public static <T> DynamicRegistry<T> fromMap(Key key, Map.Entry<Key, T> ... entries) {
        DynamicRegistryImpl<T> registry = new DynamicRegistryImpl<T>(key, null);
        for (Map.Entry<Key, T> entry : entries) {
            registry.register(entry.getKey(), entry.getValue(), DataPack.MINESTOM_UNNAMED);
        }
        return registry.compact();
    }

    @ApiStatus.Internal
    public static <T> DynamicRegistry<T> create(Key key) {
        return new DynamicRegistryImpl(key, null);
    }

    @ApiStatus.Internal
    public static <T> DynamicRegistry<T> create(Key key, Codec<T> codec) {
        return new DynamicRegistryImpl<T>(key, codec);
    }

    @ApiStatus.Internal
    public static <T> DynamicRegistry<T> create(Key key, Codec<T> codec, RegistryData.Resource resource) {
        return DynamicRegistry.create(key, codec, null, resource, null, null);
    }

    @ApiStatus.Internal
    public static <T> DynamicRegistry<T> create(Key key, Codec<T> codec, @Nullable Registries registries, RegistryData.Resource resource) {
        return DynamicRegistry.create(key, codec, registries, resource, null, null);
    }

    @ApiStatus.Internal
    public static <T> DynamicRegistry<T> create(Key key, Codec<T> codec, @Nullable Registries registries, RegistryData.Resource resource, @Nullable Comparator<String> idComparator, @Nullable Codec<T> readCodec) {
        DynamicRegistryImpl<T> registry = new DynamicRegistryImpl<T>(key, codec);
        DynamicRegistryImpl.loadStaticJsonRegistry(registries, registry, resource, idComparator, Objects.requireNonNullElse(readCodec, codec));
        return registry.compact();
    }

    @ApiStatus.Internal
    public static DynamicRegistry<Enchantment> createForEnchantmentsWithSelfReferentialLoadingNightmare(Key key, Codec<Enchantment> codec, RegistryData.Resource resource, Registries registries) {
        final DynamicRegistryImpl<Enchantment> registry = new DynamicRegistryImpl<Enchantment>(key, codec);
        DynamicRegistryImpl.loadStaticJsonRegistry(new Registries.Delegating(registries){

            @Override
            public DynamicRegistry<Enchantment> enchantment() {
                return registry;
            }
        }, registry, resource, null, codec);
        return registry.compact();
    }

    @ApiStatus.Internal
    public static DynamicRegistry<Dialog> createForDialogWithSelfReferentialLoadingNightmare(Key key, Codec<Dialog> codec, RegistryData.Resource resource, Registries registries) {
        final DynamicRegistryImpl<Dialog> registry = new DynamicRegistryImpl<Dialog>(key, codec);
        DynamicRegistryImpl.loadStaticJsonRegistry(new Registries.Delegating(registries){

            @Override
            public DynamicRegistry<Dialog> dialog() {
                return registry;
            }
        }, registry, resource, null, codec);
        return registry;
    }

    default public RegistryKey<T> register(String id, T object) {
        return this.register(Key.key(id), object, DataPack.MINESTOM_UNNAMED);
    }

    default public RegistryKey<T> register(Key id, T object) {
        return this.register(id, object, DataPack.MINESTOM_UNNAMED);
    }

    @ApiStatus.Internal
    default public RegistryKey<T> register(String id, T object, DataPack pack) {
        return this.register(Key.key(id), object, pack);
    }

    @ApiStatus.Internal
    public RegistryKey<T> register(Key var1, T var2, DataPack var3);

    public boolean remove(Key var1) throws UnsupportedOperationException;

    @ApiStatus.Internal
    public SendablePacket registryDataPacket(Registries var1, boolean var2);
}

