/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryCodecs;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.registry.RegistryNetworkTypes;
import net.minestom.server.utils.Either;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public sealed interface Holder<T>
permits RegistryKey, Direct {
    public static <T extends Holder<T>> NetworkBuffer.Type<Holder<T>> networkType(Registries.Selector<T> selector, NetworkBuffer.Type<T> registryNetworkType) {
        return new RegistryNetworkTypes.HolderNetworkTypeImpl<T>(selector, registryNetworkType);
    }

    public static <T extends Holder<T>> Codec<Holder<T>> codec(Registries.Selector<T> selector, Codec<T> registryCodec) {
        return new RegistryCodecs.HolderCodec<T>(selector, registryCodec);
    }

    default public boolean isDirect() {
        return !(this instanceof RegistryKey);
    }

    @Nullable
    default public RegistryKey<T> asKey() {
        return this instanceof RegistryKey ? (RegistryKey)this : null;
    }

    @Nullable
    default public T asValue() {
        return (T)(this instanceof RegistryKey ? null : this);
    }

    default public Either<RegistryKey<T>, T> unwrap() {
        Holder holder = this;
        if (holder instanceof RegistryKey) {
            RegistryKey key = (RegistryKey)holder;
            return Either.left(key);
        }
        return Either.right(this);
    }

    @Nullable
    default public T resolve(DynamicRegistry<T> registry) {
        RegistryKey<T> key = this.asKey();
        if (key != null) {
            return registry.get(key);
        }
        return (T)this;
    }

    @ApiStatus.NonExtendable
    public static interface Direct<T>
    extends Holder<T> {
    }
}

