/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.util.Collection;
import java.util.List;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.HolderSet;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryCodecs;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.registry.RegistryNetworkTypes;
import net.minestom.server.registry.RegistryTagImpl;
import net.minestom.server.registry.TagKey;
import org.jetbrains.annotations.Nullable;

public sealed interface RegistryTag<T>
extends HolderSet<T>,
Iterable<RegistryKey<T>>
permits RegistryTagImpl.Empty, RegistryTagImpl.Backed, RegistryTagImpl.Direct {
    public static <T> NetworkBuffer.Type<RegistryTag<T>> networkType(Registries.Selector<T> selector) {
        return new RegistryNetworkTypes.RegistryTagImpl<T>(selector);
    }

    public static <T> Codec<RegistryTag<T>> codec(Registries.Selector<T> selector) {
        return new RegistryCodecs.RegistryTagImpl<T>(selector);
    }

    public static <T> RegistryTag<T> empty() {
        return RegistryTagImpl.Empty.INSTANCE;
    }

    @SafeVarargs
    public static <T> RegistryTag<T> direct(RegistryKey<T> ... keys) {
        if (keys.length == 0) {
            return RegistryTag.empty();
        }
        return new RegistryTagImpl.Direct<T>(List.of(keys));
    }

    public static <T> RegistryTag<T> direct(Collection<RegistryKey<T>> values) {
        if (values.isEmpty()) {
            return RegistryTag.empty();
        }
        return new RegistryTagImpl.Direct<T>(List.copyOf(values));
    }

    @Nullable
    public TagKey<T> key();

    public boolean contains(RegistryKey<T> var1);

    public int size();
}

