/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryCodecs;
import net.minestom.server.registry.TagKeyImpl;

public sealed interface TagKey<T>
extends Keyed
permits TagKeyImpl {
    public static <T> Codec<TagKey<T>> codec(Registries.Selector<T> selector) {
        return new RegistryCodecs.TagKeyImpl<T>(selector, false);
    }

    public static <T> Codec<TagKey<T>> hashCodec(Registries.Selector<T> selector) {
        return new RegistryCodecs.TagKeyImpl<T>(selector, true);
    }

    public static <T> NetworkBuffer.Type<TagKey<T>> networkType(Registries.Selector<T> selector) {
        return NetworkBuffer.KEY.transform(TagKeyImpl::new, Keyed::key);
    }

    public static <T> TagKey<T> ofHash(String hashedKey) {
        if (!hashedKey.startsWith("#")) {
            throw new IllegalArgumentException("Hashed key must start with '#': " + hashedKey);
        }
        return new TagKeyImpl(Key.key(hashedKey.substring(1)));
    }

    default public String hashedKey() {
        return "#" + this.key().asString();
    }
}

