/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.Range;

sealed interface StaticIntMap<T> {
    public T get(@Range(from=0L, to=0x7FFFFFFFL) int var1);

    public void forValues(Consumer<T> var1);

    public StaticIntMap<T> copy();

    public void put(@Range(from=0L, to=0x7FFFFFFFL) int var1, T var2);

    public void remove(@Range(from=0L, to=0x7FFFFFFFL) int var1);

    public void updateContent(StaticIntMap<T> var1);

    public static final class Array<T>
    implements StaticIntMap<T> {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private T[] array;

        public Array(T[] array) {
            this.array = array;
        }

        public Array() {
            this.array = EMPTY_ARRAY;
        }

        @Override
        public T get(int key) {
            T[] array = this.array;
            return key < array.length ? (T)array[key] : null;
        }

        @Override
        public void forValues(Consumer<T> consumer) {
            T[] array;
            for (T value : array = this.array) {
                if (value == null) continue;
                consumer.accept(value);
            }
        }

        @Override
        public StaticIntMap<T> copy() {
            return new Array<Object>((Object[])this.array.clone());
        }

        @Override
        public void put(int key, T value) {
            T[] array = this.array;
            if (key >= array.length) {
                array = this.updateArray(Arrays.copyOf(array, key * 2 + 1));
            }
            array[key] = value;
        }

        @Override
        public void updateContent(StaticIntMap<T> content) {
            if (!(content instanceof Array)) {
                throw new IllegalArgumentException("Invalid content type: " + String.valueOf(content.getClass()));
            }
            Array arrayMap = (Array)content;
            this.updateArray((Object[])arrayMap.array.clone());
        }

        @Override
        public void remove(int key) {
            T[] array = this.array;
            if (key < array.length) {
                array[key] = null;
            }
        }

        T[] updateArray(T[] result) {
            this.array = result;
            return result;
        }
    }
}

