/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minestom.server.entity.Entity;
import net.minestom.server.thread.AcquirableImpl;
import net.minestom.server.thread.Acquired;
import net.minestom.server.thread.TickThread;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Experimental
public sealed interface Acquirable<T>
permits AcquirableImpl {
    public static Stream<Entity> localEntities() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof TickThread)) {
            return Stream.empty();
        }
        TickThread tickThread = (TickThread)thread;
        return tickThread.entries.stream().flatMap(partitionEntry -> partitionEntry.elements().stream()).filter(tickable -> tickable instanceof Entity).map(tickable -> (Entity)tickable);
    }

    @ApiStatus.Internal
    public static long resetAcquiringTime() {
        return AcquirableImpl.WAIT_COUNTER_NANO.getAndSet(0L);
    }

    @ApiStatus.Internal
    public static <T> Acquirable<T> unassigned(T value) {
        return new AcquirableImpl<T>(value);
    }

    public Acquired<T> lock();

    default public Optional<T> local() {
        return this.isLocal() ? Optional.of(this.unwrap()) : Optional.empty();
    }

    public boolean isLocal();

    default public Optional<T> owned() {
        return this.isOwned() ? Optional.of(this.unwrap()) : Optional.empty();
    }

    public boolean isOwned();

    public void sync(Consumer<T> var1);

    public boolean trySync(Consumer<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> R applySync(Function<T, R> function) {
        Acquired<T> acquired = this.lock();
        try {
            R r = function.apply(acquired.get());
            return r;
        }
        finally {
            acquired.unlock();
        }
    }

    public T unwrap();

    public @UnknownNullability TickThread assignedThread();

    public void assertOwnership();
}

