/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.thread.AcquirableImpl;
import net.minestom.server.thread.TickThread;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class AcquirableCollection<E>
implements Collection<Acquirable<E>> {
    private final Collection<Acquirable<E>> acquirableCollection;

    public AcquirableCollection(Collection<Acquirable<E>> acquirableCollection) {
        this.acquirableCollection = acquirableCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireSync(Consumer<E> consumer) {
        Map threadEntitiesMap = AcquirableCollection.retrieveOptionalThreadMap(this.acquirableCollection, consumer);
        for (Map.Entry entry : threadEntitiesMap.entrySet()) {
            TickThread tickThread = entry.getKey();
            ReentrantLock lock = AcquirableImpl.enter(tickThread);
            try {
                List values = entry.getValue();
                for (Object value : values) {
                    consumer.accept(value);
                }
            }
            finally {
                AcquirableImpl.leave(lock);
            }
        }
    }

    public Stream<E> unwrap() {
        return this.acquirableCollection.stream().map(Acquirable::unwrap);
    }

    @Override
    public int size() {
        return this.acquirableCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.acquirableCollection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.acquirableCollection.contains(o);
    }

    @Override
    public Iterator<Acquirable<E>> iterator() {
        return this.acquirableCollection.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.acquirableCollection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.acquirableCollection.toArray(a);
    }

    @Override
    public boolean add(Acquirable<E> eAcquirable) {
        return this.acquirableCollection.add(eAcquirable);
    }

    @Override
    public boolean remove(Object o) {
        return this.acquirableCollection.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.acquirableCollection.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Acquirable<E>> c) {
        return this.acquirableCollection.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.acquirableCollection.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.acquirableCollection.retainAll(c);
    }

    @Override
    public void clear() {
        this.acquirableCollection.clear();
    }

    protected static <T> Map<TickThread, List<T>> retrieveOptionalThreadMap(Collection<Acquirable<T>> collection, Consumer<T> consumer) {
        HashMap<TickThread, List<T>> threadCacheMap = new HashMap<TickThread, List<T>>();
        for (Acquirable<T> element : collection) {
            T value = element.unwrap();
            TickThread elementThread = element.assignedThread();
            if (Thread.currentThread() == elementThread) {
                consumer.accept(value);
                continue;
            }
            List threadCacheList = threadCacheMap.computeIfAbsent(elementThread, tickThread -> new ArrayList());
            threadCacheList.add(value);
        }
        return threadCacheMap;
    }
}

