/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.minestom.server.ServerFlag;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.thread.AcquirableOwnershipException;
import net.minestom.server.thread.Acquired;
import net.minestom.server.thread.AcquiredImpl;
import net.minestom.server.thread.TickThread;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

final class AcquirableImpl<T>
implements Acquirable<T> {
    private static final boolean ASSERTIONS_ENABLED = AcquirableImpl.class.desiredAssertionStatus();
    static final AtomicLong WAIT_COUNTER_NANO = new AtomicLong();
    static final ReentrantLock GLOBAL_LOCK = new ReentrantLock();
    private final T value;
    private final Thread initThread = Thread.currentThread();
    private volatile TickThread assignedThread;

    public AcquirableImpl(T value) {
        this.value = value;
    }

    @Override
    public Acquired<T> lock() {
        TickThread assignedThread = this.assignedThread;
        if (assignedThread == null) {
            this.assertInitThread();
            return new AcquiredImpl<T>(this.unwrap(), null);
        }
        ReentrantLock lock = AcquirableImpl.enter(assignedThread);
        assert (assignedThread.lock().isHeldByCurrentThread());
        return new AcquiredImpl<T>(this.unwrap(), lock);
    }

    @Override
    public boolean isLocal() {
        TickThread assignedThread = this.assignedThread;
        return Thread.currentThread() == Objects.requireNonNullElse(assignedThread, this.initThread);
    }

    @Override
    public boolean isOwned() {
        TickThread assignedThread = this.assignedThread;
        if (assignedThread == null) {
            return Thread.currentThread() == this.initThread;
        }
        return AcquirableImpl.isOwnedImpl(assignedThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(Consumer<T> consumer) {
        TickThread assignedThread = this.assignedThread;
        if (assignedThread == null) {
            this.assertInitThread();
            consumer.accept(this.unwrap());
            return;
        }
        ReentrantLock lock = AcquirableImpl.enter(assignedThread);
        try {
            assert (assignedThread.lock().isHeldByCurrentThread());
            consumer.accept(this.unwrap());
        }
        finally {
            AcquirableImpl.leave(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trySync(Consumer<T> consumer) {
        ReentrantLock lock;
        if (this.isOwned()) {
            consumer.accept(this.unwrap());
            return true;
        }
        TickThread assignedThread = this.assignedThread;
        if (assignedThread != null && (lock = assignedThread.lock()).tryLock()) {
            try {
                consumer.accept(this.unwrap());
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    @Override
    public T unwrap() {
        return this.value;
    }

    @Override
    public @UnknownNullability TickThread assignedThread() {
        return this.assignedThread;
    }

    void assign(TickThread thread) {
        this.assignedThread = thread;
    }

    @Override
    public void assertOwnership() {
        if (!ASSERTIONS_ENABLED && !ServerFlag.ACQUIRABLE_STRICT) {
            return;
        }
        if (this.isOwned()) {
            return;
        }
        TickThread assignedThread = this.assignedThread;
        Thread initThread = this.initThread;
        if (assignedThread == null && Thread.currentThread() == initThread) {
            return;
        }
        throw new AcquirableOwnershipException(initThread, assignedThread, this.unwrap().toString());
    }

    void assertInitThread() {
        if (Thread.currentThread() != this.initThread) {
            throw new IllegalStateException("Cannot lock an uninitialized Acquirable from a different thread");
        }
    }

    static boolean isOwnedImpl(TickThread elementThread) {
        if (Thread.currentThread() == elementThread) {
            return true;
        }
        return elementThread.lock().isHeldByCurrentThread();
    }

    @Nullable
    static ReentrantLock enter(TickThread elementThread) {
        TickThread tickThread;
        if (AcquirableImpl.isOwnedImpl(elementThread)) {
            return null;
        }
        long time = System.nanoTime();
        Thread thread = Thread.currentThread();
        if (thread instanceof TickThread && (tickThread = (TickThread)thread).lock().isHeldByCurrentThread()) {
            while (!GLOBAL_LOCK.tryLock()) {
                tickThread.lock().unlock();
                tickThread.lock().lock();
            }
        } else {
            GLOBAL_LOCK.lock();
        }
        ReentrantLock targetLock = elementThread.lock();
        targetLock.lock();
        WAIT_COUNTER_NANO.addAndGet(System.nanoTime() - time);
        return targetLock;
    }

    static void leave(@Nullable ReentrantLock lock) {
        if (lock != null) {
            lock.unlock();
            GLOBAL_LOCK.unlock();
        }
    }
}

