/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class AcquirableOwnershipException
extends RuntimeException {
    private final Thread initThread;
    private final Thread assignedThread;
    private final Object element;

    @ApiStatus.Internal
    public AcquirableOwnershipException(Thread initThread, @Nullable Thread assignedThread, Object element) {
        super(AcquirableOwnershipException.buildMessage(initThread, assignedThread, element));
        this.initThread = initThread;
        this.assignedThread = assignedThread;
        this.element = element;
    }

    private static String buildMessage(Thread initThread, @Nullable Thread assignedThread, Object value) {
        String valueString = value.toString();
        if (assignedThread != null) {
            return "Thread ownership assertion failed for %s:\n  Current thread:  %s\n  Assigned thread: %s\n  Problem: The element is assigned to a different thread and is not currently owned.\n  Solution: Use Acquirable#sync() or Acquirable#lock() to acquire ownership before accessing the element.\n".formatted(valueString, Thread.currentThread().getName(), assignedThread.getName());
        }
        return "Thread ownership assertion failed for %s:\n  Current thread:        %s\n  Initialization thread: %s\n  Problem: The element is not yet initialized and is being accessed from a different thread.\n  Solution: Handle the element in the same thread it has been initialized in until it is fully initialized.\n".formatted(valueString, Thread.currentThread().getName(), initThread.getName());
    }

    public Thread initThread() {
        return this.initThread;
    }

    @Nullable
    public Thread assignedThread() {
        return this.assignedThread;
    }

    public Object element() {
        return this.element;
    }
}

