/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.concurrent.locks.ReentrantLock;
import net.minestom.server.thread.AcquirableImpl;
import net.minestom.server.thread.Acquired;
import net.minestom.server.utils.validate.Check;

final class AcquiredImpl<T>
implements Acquired<T> {
    private final T value;
    private final Thread owner;
    private final ReentrantLock lock;
    private boolean unlocked;

    AcquiredImpl(T value, ReentrantLock lock) {
        this.value = value;
        this.owner = Thread.currentThread();
        this.lock = lock;
    }

    @Override
    public T get() {
        this.safeCheck();
        return this.value;
    }

    @Override
    public void unlock() {
        this.safeCheck();
        this.unlocked = true;
        AcquirableImpl.leave(this.lock);
    }

    private void safeCheck() {
        Check.stateCondition(Thread.currentThread() != this.owner, "Acquired object is owned by the thread {0}", this.owner);
        Check.stateCondition(this.unlocked, "The acquired element has already been unlocked!");
    }
}

