/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.List;
import java.util.function.IntFunction;
import net.minestom.server.Tickable;
import net.minestom.server.thread.ThreadDispatcherImpl;
import net.minestom.server.thread.ThreadProvider;
import net.minestom.server.thread.TickThread;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;

public sealed interface ThreadDispatcher<P, E extends Tickable>
permits ThreadDispatcherImpl {
    @Contract(pure=true)
    public static <P, E extends Tickable> ThreadDispatcher<P, E> dispatcher(ThreadProvider<P> provider, int threadCount) {
        return new ThreadDispatcherImpl(provider, threadCount, TickThread::new);
    }

    @Contract(pure=true)
    public static <P, E extends Tickable> ThreadDispatcher<P, E> dispatcher(ThreadProvider<P> provider, IntFunction<String> nameGenerator, int threadCount) {
        return new ThreadDispatcherImpl(provider, threadCount, index -> new TickThread((String)nameGenerator.apply(index)));
    }

    @Contract(pure=true)
    public static <P, E extends Tickable> ThreadDispatcher<P, E> singleThread() {
        return ThreadDispatcher.dispatcher(ThreadProvider.counter(), 1);
    }

    @ApiStatus.Internal
    public @Unmodifiable List<TickThread> threads();

    public void updateAndAwait(long var1);

    public void refreshThreads(long var1);

    default public void refreshThreads() {
        this.refreshThreads(Long.MAX_VALUE);
    }

    public void signalUpdate(Update<P, E> var1);

    default public void createPartition(P partition) {
        this.signalUpdate(new Update.PartitionLoad(partition));
    }

    default public void deletePartition(P partition) {
        this.signalUpdate(new Update.PartitionUnload(partition));
    }

    default public void updateElement(E element, P partition) {
        this.signalUpdate(new Update.ElementUpdate<P, E>(element, partition));
    }

    default public void removeElement(E element) {
        this.signalUpdate(new Update.ElementRemove(element));
    }

    public void start();

    public boolean isAlive();

    public void shutdown();

    @ApiStatus.Internal
    public static sealed interface Update<P, E> {

        public record ElementRemove<P, E>(E element) implements Update<P, E>
        {
        }

        public record ElementUpdate<P, E>(E element, P partition) implements Update<P, E>
        {
        }

        public record PartitionUnload<P, E>(P partition) implements Update<P, E>
        {
        }

        public record PartitionLoad<P, E>(P partition) implements Update<P, E>
        {
        }
    }
}

