/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.IntFunction;
import net.minestom.server.Tickable;
import net.minestom.server.thread.AcquirableImpl;
import net.minestom.server.thread.AcquirableSource;
import net.minestom.server.thread.ThreadDispatcher;
import net.minestom.server.thread.ThreadProvider;
import net.minestom.server.thread.TickThread;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;

final class ThreadDispatcherImpl<P, E extends Tickable>
implements ThreadDispatcher<P, E> {
    private final ThreadProvider<P> provider;
    private final List<TickThread> threads;
    private final Map<P, Partition> partitions = new WeakHashMap<P, Partition>();
    private final Map<Tickable, Partition> elements = new WeakHashMap<Tickable, Partition>();
    private final ArrayDeque<P> partitionUpdateQueue = new ArrayDeque();
    private final MessagePassingQueue<ThreadDispatcher.Update<P, E>> updates = new MpscUnboundedArrayQueue<ThreadDispatcher.Update<P, E>>(1024);

    ThreadDispatcherImpl(ThreadProvider<P> provider, int threadCount, IntFunction<? extends TickThread> threadGenerator) {
        this.provider = provider;
        TickThread[] threads = new TickThread[threadCount];
        Arrays.setAll(threads, threadGenerator);
        this.threads = List.of(threads);
    }

    @Override
    @ApiStatus.Internal
    public @Unmodifiable List<TickThread> threads() {
        return this.threads;
    }

    @Override
    public synchronized void updateAndAwait(long time) {
        this.updates.drain(update -> {
            ThreadDispatcher.Update selector0$temp = update;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ThreadDispatcher.Update.PartitionLoad.class, ThreadDispatcher.Update.PartitionUnload.class, ThreadDispatcher.Update.ElementUpdate.class, ThreadDispatcher.Update.ElementRemove.class}, (ThreadDispatcher.Update)selector0$temp, index$1)) {
                case 0: {
                    ThreadDispatcher.Update.PartitionLoad chunkUpdate = (ThreadDispatcher.Update.PartitionLoad)selector0$temp;
                    this.processLoadedPartition(chunkUpdate.partition());
                    break;
                }
                case 1: {
                    ThreadDispatcher.Update.PartitionUnload partitionUnload = (ThreadDispatcher.Update.PartitionUnload)selector0$temp;
                    this.processUnloadedPartition(partitionUnload.partition());
                    break;
                }
                case 2: {
                    ThreadDispatcher.Update.ElementUpdate elementUpdate = (ThreadDispatcher.Update.ElementUpdate)selector0$temp;
                    this.processUpdatedElement((Tickable)elementUpdate.element(), elementUpdate.partition());
                    break;
                }
                case 3: {
                    ThreadDispatcher.Update.ElementRemove elementRemove = (ThreadDispatcher.Update.ElementRemove)selector0$temp;
                    this.processRemovedElement((Tickable)elementRemove.element());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown update type: " + (update == null ? "null" : update.getClass().getSimpleName()));
                }
            }
        });
        CountDownLatch latch = new CountDownLatch(this.threads.size());
        for (TickThread thread : this.threads) {
            thread.startTick(latch, time);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void refreshThreads(long nanoTimeout) {
        block0 : switch (this.provider.refreshType()) {
            case NEVER: {
                break;
            }
            case ALWAYS: {
                P partition;
                long currentTime = System.nanoTime();
                int counter = this.partitionUpdateQueue.size();
                while ((partition = this.partitionUpdateQueue.pollFirst()) != null) {
                    Partition partitionEntry = this.partitions.get(partition);
                    assert (partitionEntry != null);
                    TickThread previous = partitionEntry.thread;
                    TickThread next = this.retrieveThread(partition);
                    if (next != previous) {
                        partitionEntry.thread = next;
                        previous.entries.remove(partitionEntry);
                        next.entries.add(partitionEntry);
                    }
                    this.partitionUpdateQueue.addLast(partition);
                    if (--counter > 0 && System.nanoTime() - currentTime < nanoTimeout) continue;
                    break block0;
                }
                break;
            }
        }
    }

    @Override
    public void refreshThreads() {
        this.refreshThreads(Long.MAX_VALUE);
    }

    @Override
    public synchronized void start() {
        this.threads.forEach(Thread::start);
    }

    @Override
    public boolean isAlive() {
        for (TickThread thread : this.threads) {
            if (thread.isAlive()) continue;
            return false;
        }
        return !this.threads.isEmpty();
    }

    @Override
    public synchronized void shutdown() {
        this.threads.forEach(TickThread::shutdown);
    }

    private TickThread retrieveThread(P partition) {
        int threadId = this.provider.findThread(partition);
        int index = Math.abs(threadId) % this.threads.size();
        return this.threads.get(index);
    }

    @Override
    public void signalUpdate(ThreadDispatcher.Update<P, E> update) {
        this.updates.relaxedOffer(update);
    }

    private void processLoadedPartition(P partition) {
        if (this.partitions.containsKey(partition)) {
            return;
        }
        TickThread thread = this.retrieveThread(partition);
        Partition partitionEntry = new Partition(thread);
        thread.entries.add(partitionEntry);
        this.partitions.put(partition, partitionEntry);
        this.partitionUpdateQueue.add(partition);
        if (partition instanceof Tickable) {
            Tickable tickable = (Tickable)partition;
            this.processUpdatedElement(tickable, partition);
        }
    }

    private void processUnloadedPartition(P partition) {
        Partition partitionEntry = this.partitions.remove(partition);
        if (partitionEntry != null) {
            TickThread thread = partitionEntry.thread;
            thread.entries.remove(partitionEntry);
        }
        this.partitionUpdateQueue.remove(partition);
        if (partition instanceof Tickable) {
            Tickable tickable = (Tickable)partition;
            this.processRemovedElement(tickable);
        }
    }

    private void processRemovedElement(Tickable tickable) {
        Partition partition = this.elements.get(tickable);
        if (partition != null) {
            partition.elements.remove(tickable);
        }
    }

    private void processUpdatedElement(Tickable tickable, P partition) {
        Partition partitionEntry = this.elements.get(tickable);
        if (partitionEntry != null) {
            partitionEntry.elements.remove(tickable);
        }
        if ((partitionEntry = this.partitions.get(partition)) != null) {
            this.elements.put(tickable, partitionEntry);
            partitionEntry.elements.add(tickable);
            if (tickable instanceof AcquirableSource) {
                AcquirableSource acquirableSource = (AcquirableSource)((Object)tickable);
                ((AcquirableImpl)acquirableSource.acquirable()).assign(partitionEntry.thread());
            }
        }
    }

    public static final class Partition {
        private TickThread thread;
        private final List<Tickable> elements = new ArrayList<Tickable>();

        private Partition(TickThread thread) {
            this.thread = thread;
        }

        @ApiStatus.Internal
        public TickThread thread() {
            return this.thread;
        }

        public List<Tickable> elements() {
            return this.elements;
        }
    }
}

