/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minestom.server.timer.ExecutionType;
import net.minestom.server.timer.SchedulerImpl;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.timer.Task;
import net.minestom.server.timer.TaskSchedule;

public sealed interface Scheduler
extends Executor
permits SchedulerImpl, SchedulerManager {
    public static Scheduler newScheduler() {
        return new SchedulerImpl();
    }

    public void process();

    public void processTick();

    public void processTickEnd();

    public Task submitTask(Supplier<TaskSchedule> var1, ExecutionType var2);

    default public Task submitTask(Supplier<TaskSchedule> task) {
        return this.submitTask(task, ExecutionType.TICK_START);
    }

    default public Task.Builder buildTask(Runnable task) {
        return new Task.Builder(this, task);
    }

    default public Task scheduleTask(Runnable task, TaskSchedule delay, TaskSchedule repeat, ExecutionType executionType) {
        return this.buildTask(task).delay(delay).repeat(repeat).executionType(executionType).schedule();
    }

    default public Task scheduleTask(Runnable task, TaskSchedule delay, TaskSchedule repeat) {
        return this.scheduleTask(task, delay, repeat, ExecutionType.TICK_START);
    }

    default public Task scheduleTask(Supplier<TaskSchedule> task, TaskSchedule delay) {
        return new Task.Builder(this, task).delay(delay).schedule();
    }

    default public Task scheduleNextTick(Runnable task, ExecutionType executionType) {
        return this.buildTask(task).delay(TaskSchedule.nextTick()).executionType(executionType).schedule();
    }

    default public Task scheduleNextTick(Runnable task) {
        return this.scheduleNextTick(task, ExecutionType.TICK_START);
    }

    default public Task scheduleEndOfTick(Runnable task) {
        return this.scheduleNextProcess(task, ExecutionType.TICK_END);
    }

    default public Task scheduleNextProcess(Runnable task, ExecutionType executionType) {
        return this.buildTask(task).delay(TaskSchedule.immediate()).executionType(executionType).schedule();
    }

    default public Task scheduleNextProcess(Runnable task) {
        return this.scheduleNextProcess(task, ExecutionType.TICK_START);
    }

    @Override
    default public void execute(Runnable command) {
        this.scheduleNextTick(command);
    }
}

