/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minestom.server.MinecraftServer;
import net.minestom.server.timer.ExecutionType;
import net.minestom.server.timer.Scheduler;
import net.minestom.server.timer.Task;
import net.minestom.server.timer.TaskImpl;
import net.minestom.server.timer.TaskSchedule;
import net.minestom.server.timer.TaskScheduleImpl;
import org.jctools.queues.MpscUnboundedArrayQueue;

final class SchedulerImpl
implements Scheduler {
    private static final AtomicInteger TASK_COUNTER = new AtomicInteger();
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        return thread;
    });
    private final MpscUnboundedArrayQueue<TaskImpl> tasksToExecute = new MpscUnboundedArrayQueue(64);
    private final MpscUnboundedArrayQueue<TaskImpl> tickEndTasksToExecute = new MpscUnboundedArrayQueue(64);
    private final Int2ObjectAVLTreeMap<List<TaskImpl>> tickStartTaskQueue = new Int2ObjectAVLTreeMap();
    private final Int2ObjectAVLTreeMap<List<TaskImpl>> tickEndTaskQueue = new Int2ObjectAVLTreeMap();
    private int tickState;

    SchedulerImpl() {
    }

    @Override
    public void process() {
        this.processTick(0);
    }

    @Override
    public void processTick() {
        this.processTick(1);
    }

    private void processTick(int tickDelta) {
        this.processTickTasks(this.tickStartTaskQueue, this.tasksToExecute, tickDelta);
    }

    @Override
    public void processTickEnd() {
        this.processTickTasks(this.tickEndTaskQueue, this.tickEndTasksToExecute, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTickTasks(Int2ObjectAVLTreeMap<List<TaskImpl>> targetTaskQueue, MpscUnboundedArrayQueue<TaskImpl> targetTasksToExecute, int tickDelta) {
        SchedulerImpl schedulerImpl = this;
        synchronized (schedulerImpl) {
            int tickToProcess;
            this.tickState += tickDelta;
            while (!targetTaskQueue.isEmpty() && (tickToProcess = targetTaskQueue.firstIntKey()) <= this.tickState) {
                MpscUnboundedArrayQueue<TaskImpl> mpscUnboundedArrayQueue;
                List<TaskImpl> tickScheduledTasks = targetTaskQueue.remove(tickToProcess);
                if (tickScheduledTasks == null) continue;
                Objects.requireNonNull(targetTasksToExecute);
                tickScheduledTasks.forEach(x$0 -> mpscUnboundedArrayQueue.relaxedOffer(x$0));
            }
        }
        this.runTasks(targetTasksToExecute);
    }

    private void runTasks(MpscUnboundedArrayQueue<TaskImpl> targetQueue) {
        if (!targetQueue.isEmpty()) {
            targetQueue.drain(task -> {
                if (!task.isAlive()) {
                    return;
                }
                this.handleTask((TaskImpl)task);
            });
        }
    }

    @Override
    public Task submitTask(Supplier<TaskSchedule> task, ExecutionType executionType) {
        TaskImpl taskRef = new TaskImpl(TASK_COUNTER.getAndIncrement(), task, executionType, this);
        this.handleTask(taskRef);
        return taskRef;
    }

    void unparkTask(TaskImpl task) {
        if (task.tryUnpark()) {
            this.tasksToExecute.relaxedOffer((Object)task);
        }
    }

    private void safeExecute(TaskImpl task) {
        switch (task.executionType()) {
            case TICK_START: {
                this.tasksToExecute.offer((Object)task);
                break;
            }
            case TICK_END: {
                this.tickEndTasksToExecute.offer((Object)task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTask(TaskImpl task) {
        TaskSchedule schedule;
        try {
            schedule = task.task().get();
        }
        catch (Throwable t) {
            MinecraftServer.getExceptionManager().handleException(new RuntimeException("Exception in scheduled task", t));
            schedule = TaskSchedule.stop();
        }
        TaskSchedule taskSchedule = schedule;
        Objects.requireNonNull(taskSchedule);
        TaskSchedule taskSchedule2 = taskSchedule;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TaskScheduleImpl.DurationSchedule.class, TaskScheduleImpl.TickSchedule.class, TaskScheduleImpl.FutureSchedule.class, TaskScheduleImpl.Park.class, TaskScheduleImpl.Stop.class, TaskScheduleImpl.Immediate.class}, (TaskSchedule)taskSchedule2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                TaskScheduleImpl.DurationSchedule durationSchedule = (TaskScheduleImpl.DurationSchedule)taskSchedule2;
                Duration duration = durationSchedule.duration();
                SCHEDULER.schedule(() -> this.safeExecute(task), duration.toMillis(), TimeUnit.MILLISECONDS);
                break;
            }
            case 1: {
                TaskScheduleImpl.TickSchedule tickSchedule = (TaskScheduleImpl.TickSchedule)taskSchedule2;
                SchedulerImpl schedulerImpl = this;
                synchronized (schedulerImpl) {
                    int target = this.tickState + tickSchedule.tick();
                    Int2ObjectAVLTreeMap<List<TaskImpl>> targetTaskQueue = switch (task.executionType()) {
                        default -> throw new MatchException(null, null);
                        case ExecutionType.TICK_START -> this.tickStartTaskQueue;
                        case ExecutionType.TICK_END -> this.tickEndTaskQueue;
                    };
                    targetTaskQueue.computeIfAbsent(target, i -> new ArrayList()).add(task);
                    break;
                }
            }
            case 2: {
                TaskScheduleImpl.FutureSchedule futureSchedule = (TaskScheduleImpl.FutureSchedule)taskSchedule2;
                futureSchedule.future().thenRun(() -> this.safeExecute(task));
                break;
            }
            case 3: {
                TaskScheduleImpl.Park ignored = (TaskScheduleImpl.Park)taskSchedule2;
                task.parked = true;
                break;
            }
            case 4: {
                TaskScheduleImpl.Stop ignored = (TaskScheduleImpl.Stop)taskSchedule2;
                task.cancel();
                break;
            }
            case 5: {
                TaskScheduleImpl.Immediate ignored = (TaskScheduleImpl.Immediate)taskSchedule2;
                if (task.executionType() == ExecutionType.TICK_END) {
                    this.tickEndTasksToExecute.relaxedOffer((Object)task);
                    break;
                }
                this.tasksToExecute.relaxedOffer((Object)task);
            }
        }
    }
}

