/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.CompletableFuture;
import net.minestom.server.timer.TaskScheduleImpl;

public sealed interface TaskSchedule
permits TaskScheduleImpl.DurationSchedule, TaskScheduleImpl.FutureSchedule, TaskScheduleImpl.Immediate, TaskScheduleImpl.Park, TaskScheduleImpl.Stop, TaskScheduleImpl.TickSchedule {
    public static TaskSchedule duration(Duration duration) {
        return new TaskScheduleImpl.DurationSchedule(duration);
    }

    public static TaskSchedule tick(int tick) {
        return new TaskScheduleImpl.TickSchedule(tick);
    }

    public static TaskSchedule future(CompletableFuture<?> future) {
        return new TaskScheduleImpl.FutureSchedule(future);
    }

    public static TaskSchedule park() {
        return TaskScheduleImpl.PARK;
    }

    public static TaskSchedule stop() {
        return TaskScheduleImpl.STOP;
    }

    public static TaskSchedule immediate() {
        return TaskScheduleImpl.IMMEDIATE;
    }

    public static TaskSchedule duration(long amount, TemporalUnit unit) {
        return TaskSchedule.duration(Duration.of(amount, unit));
    }

    public static TaskSchedule nextTick() {
        return TaskScheduleImpl.NEXT_TICK;
    }

    public static TaskSchedule hours(long hours) {
        return TaskSchedule.duration(Duration.ofHours(hours));
    }

    public static TaskSchedule minutes(long minutes) {
        return TaskSchedule.duration(Duration.ofMinutes(minutes));
    }

    public static TaskSchedule seconds(long seconds) {
        return TaskSchedule.duration(Duration.ofSeconds(seconds));
    }

    public static TaskSchedule millis(long millis) {
        return TaskSchedule.duration(Duration.ofMillis(millis));
    }
}

