/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import net.minestom.server.coordinate.Vec;

public enum Direction {
    DOWN(0, -1, 0),
    UP(0, 1, 0),
    NORTH(0, 0, -1),
    SOUTH(0, 0, 1),
    WEST(-1, 0, 0),
    EAST(1, 0, 0);

    public static final Direction[] HORIZONTAL;
    private final int normalX;
    private final int normalY;
    private final int normalZ;
    private final Vec normalVec;

    private Direction(int normalX, int normalY, int normalZ) {
        this.normalX = normalX;
        this.normalY = normalY;
        this.normalZ = normalZ;
        this.normalVec = new Vec(normalX, normalY, normalZ);
    }

    public int normalX() {
        return this.normalX;
    }

    public int normalY() {
        return this.normalY;
    }

    public int normalZ() {
        return this.normalZ;
    }

    public Vec vec() {
        return this.normalVec;
    }

    public Vec mul(double mult) {
        return this.normalVec.mul(mult);
    }

    public boolean positive() {
        return this.normalX > 0 || this.normalY > 0 || this.normalZ > 0;
    }

    public boolean negative() {
        return !this.positive();
    }

    public boolean vertical() {
        return this == UP || this == DOWN;
    }

    public boolean horizontal() {
        return !this.vertical();
    }

    public Direction opposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> DOWN;
            case 0 -> UP;
            case 5 -> WEST;
            case 4 -> EAST;
            case 2 -> SOUTH;
            case 3 -> NORTH;
        };
    }

    static {
        HORIZONTAL = new Direction[]{SOUTH, WEST, NORTH, EAST};
    }
}

