/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.chunk;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ChunkUtils {
    private ChunkUtils() {
    }

    public static CompletableFuture<Void> optionalLoadAll(Instance instance, long[] chunks, @Nullable Consumer<Chunk> eachCallback) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        AtomicInteger counter = new AtomicInteger(0);
        for (long visibleChunk : chunks) {
            instance.loadOptionalChunk(CoordConversion.chunkIndexGetX(visibleChunk), CoordConversion.chunkIndexGetZ(visibleChunk)).thenAccept(chunk -> {
                if (eachCallback != null) {
                    eachCallback.accept((Chunk)chunk);
                }
                if (counter.incrementAndGet() == chunks.length) {
                    completableFuture.complete(null);
                }
            });
        }
        return completableFuture;
    }

    public static boolean isLoaded(@Nullable Chunk chunk) {
        return chunk != null && chunk.isLoaded();
    }

    public static boolean isLoaded(Instance instance, double x, double z) {
        Chunk chunk = instance.getChunk(CoordConversion.globalToChunk(x), CoordConversion.globalToChunk(z));
        return ChunkUtils.isLoaded(chunk);
    }

    public static boolean isLoaded(Instance instance, Point point) {
        Chunk chunk = instance.getChunk(point.chunkX(), point.chunkZ());
        return ChunkUtils.isLoaded(chunk);
    }

    public static Chunk retrieve(Instance instance, Chunk originChunk, double x, double z) {
        int chunkX = CoordConversion.globalToChunk(x);
        int chunkZ = CoordConversion.globalToChunk(z);
        boolean sameChunk = originChunk != null && originChunk.getChunkX() == chunkX && originChunk.getChunkZ() == chunkZ;
        return sameChunk ? originChunk : instance.getChunk(chunkX, chunkZ);
    }

    public static Chunk retrieve(Instance instance, Chunk originChunk, Point position) {
        return ChunkUtils.retrieve(instance, originChunk, position.x(), position.z());
    }
}

