/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.nbt;

import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BinaryTagUtil {
    private static final BinaryTagType<?>[] TYPES = new BinaryTagType[]{BinaryTagTypes.END, BinaryTagTypes.BYTE, BinaryTagTypes.SHORT, BinaryTagTypes.INT, BinaryTagTypes.LONG, BinaryTagTypes.FLOAT, BinaryTagTypes.DOUBLE, BinaryTagTypes.BYTE_ARRAY, BinaryTagTypes.STRING, BinaryTagTypes.LIST, BinaryTagTypes.COMPOUND, BinaryTagTypes.INT_ARRAY, BinaryTagTypes.LONG_ARRAY};

    public static BinaryTagType<?> nbtTypeFromId(byte id) {
        Check.argCondition(id < 0 || id >= TYPES.length, "Invalid NBT type id: " + id);
        return TYPES[id];
    }

    public static Object nbtValueFromTag(BinaryTag tag) {
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)tag;
            return byteTag.value();
        }
        if (tag instanceof ShortBinaryTag) {
            ShortBinaryTag shortTag = (ShortBinaryTag)tag;
            return shortTag.value();
        }
        if (tag instanceof IntBinaryTag) {
            IntBinaryTag intTag = (IntBinaryTag)tag;
            return intTag.value();
        }
        if (tag instanceof LongBinaryTag) {
            LongBinaryTag longTag = (LongBinaryTag)tag;
            return longTag.value();
        }
        if (tag instanceof FloatBinaryTag) {
            FloatBinaryTag floatTag = (FloatBinaryTag)tag;
            return Float.valueOf(floatTag.value());
        }
        if (tag instanceof DoubleBinaryTag) {
            DoubleBinaryTag doubleTag = (DoubleBinaryTag)tag;
            return doubleTag.value();
        }
        if (tag instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)tag;
            return byteArrayTag.value();
        }
        if (tag instanceof StringBinaryTag) {
            StringBinaryTag stringTag = (StringBinaryTag)tag;
            return stringTag.value();
        }
        if (tag instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return intArrayTag.value();
        }
        if (tag instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)tag;
            return longArrayTag.value();
        }
        throw new UnsupportedOperationException("Unsupported NBT type: " + String.valueOf(tag.getClass()));
    }

    private BinaryTagUtil() {
    }
}

