/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biome;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.coordinate.Point;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.world.biome.BiomeEffects;
import net.minestom.server.world.biome.BiomeImpl;
import net.minestom.server.world.biome.Biomes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public sealed interface Biome
extends Biomes
permits BiomeImpl {
    public static final Codec<Biome> REGISTRY_CODEC = StructCodec.struct("temperature", Codec.FLOAT, Biome::temperature, "downfall", Codec.FLOAT, Biome::downfall, "has_precipitation", Codec.BOOLEAN, Biome::hasPrecipitation, "temperature_modifier", TemperatureModifier.CODEC.optional(TemperatureModifier.NONE), Biome::temperatureModifier, "effects", BiomeEffects.CODEC.optional(BiomeEffects.PLAINS_EFFECTS), Biome::effects, Biome::create);
    public static final Codec<Biome> NETWORK_CODEC = StructCodec.struct("temperature", Codec.FLOAT, Biome::temperature, "downfall", Codec.FLOAT, Biome::downfall, "has_precipitation", Codec.BOOLEAN, Biome::hasPrecipitation, "temperature_modifier", TemperatureModifier.CODEC, Biome::temperatureModifier, "effects", BiomeEffects.CODEC, Biome::effects, Biome::create);

    public static Biome create(float temperature, float downfall, boolean hasPrecipitation, TemperatureModifier temperatureModifier, BiomeEffects effects) {
        return new BiomeImpl(temperature, downfall, effects, hasPrecipitation, temperatureModifier);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    public static DynamicRegistry<Biome> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("worldgen/biome"), NETWORK_CODEC, null, RegistryData.Resource.BIOMES, (a, b) -> a.equals("minecraft:plains") ? -1 : (b.equals("minecraft:plains") ? 1 : 0), REGISTRY_CODEC);
    }

    public float temperature();

    public float downfall();

    public BiomeEffects effects();

    public boolean hasPrecipitation();

    public TemperatureModifier temperatureModifier();

    public static enum TemperatureModifier {
        NONE,
        FROZEN;

        public static final Codec<TemperatureModifier> CODEC;

        static {
            CODEC = Codec.Enum(TemperatureModifier.class);
        }
    }

    public static final class Builder {
        private float temperature = 0.25f;
        private float downfall = 0.8f;
        private BiomeEffects effects = BiomeEffects.PLAINS_EFFECTS;
        private boolean hasPrecipitation = false;
        private TemperatureModifier temperatureModifier = TemperatureModifier.NONE;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        public Builder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        public Builder downfall(float downfall) {
            this.downfall = downfall;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        public Builder effects(BiomeEffects effects) {
            this.effects = effects;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        public Builder hasPrecipitation(boolean precipitation) {
            this.hasPrecipitation = precipitation;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        public Builder temperatureModifier(TemperatureModifier temperatureModifier) {
            this.temperatureModifier = temperatureModifier;
            return this;
        }

        @Contract(pure=true)
        public Biome build() {
            return new BiomeImpl(this.temperature, this.downfall, this.effects, this.hasPrecipitation, this.temperatureModifier);
        }
    }

    public static interface Getter {
        public RegistryKey<Biome> getBiome(int var1, int var2, int var3);

        default public RegistryKey<Biome> getBiome(Point point) {
            return this.getBiome(point.blockX(), point.blockY(), point.blockZ());
        }
    }

    public static interface Setter {
        public void setBiome(int var1, int var2, int var3, RegistryKey<Biome> var4);

        default public void setBiome(Point blockPosition, RegistryKey<Biome> biome) {
            this.setBiome(blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), biome);
        }
    }
}

