/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.minestom.server.extras.mojangAuth.MojangCrypt;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.Nullable;

public sealed interface Auth {

    public record Bungee(@Nullable Set<String> bungeeGuardTokens) implements Auth
    {
        public Bungee(@Nullable Set<String> bungeeGuardTokens) {
            if (bungeeGuardTokens != null && bungeeGuardTokens.isEmpty()) {
                throw new IllegalArgumentException("BungeeGuard tokens cannot be empty");
            }
        }

        public Bungee() {
            this(null);
        }

        public boolean validToken(String token) {
            return this.bungeeGuardTokens == null || this.bungeeGuardTokens.contains(token);
        }

        public boolean guard() {
            return this.bungeeGuardTokens != null;
        }
    }

    public record Velocity(Key key) implements Auth
    {
        public static final String PLAYER_INFO_CHANNEL = "velocity:player_info";
        private static final String MAC_ALGORITHM = "HmacSHA256";
        private static final int SUPPORTED_FORWARDING_VERSION = 1;

        public Velocity(String secret) {
            this(Velocity.secretKey(secret));
        }

        public boolean checkIntegrity(NetworkBuffer buffer) {
            byte[] signature = new byte[32];
            for (int i = 0; i < signature.length; ++i) {
                signature[i] = buffer.read(NetworkBuffer.BYTE);
            }
            long index = buffer.readIndex();
            byte[] data = buffer.read(NetworkBuffer.RAW_BYTES);
            buffer.readIndex(index);
            try {
                Mac mac = Mac.getInstance(MAC_ALGORITHM);
                mac.init(this.key);
                byte[] mySignature = mac.doFinal(data);
                if (!MessageDigest.isEqual(signature, mySignature)) {
                    return false;
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            int version = buffer.read(NetworkBuffer.VAR_INT);
            return version == 1;
        }

        public static Key secretKey(String secret) {
            return new SecretKeySpec(secret.getBytes(), MAC_ALGORITHM);
        }
    }

    public record Online(KeyPair keyPair) implements Auth
    {
        public Online() {
            this(Objects.requireNonNull(MojangCrypt.generateKeyPair()));
        }
    }

    public record Offline() implements Auth
    {
    }
}

