/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minestom.server.Auth;
import net.minestom.server.MinecraftConstants;
import net.minestom.server.ServerFlag;
import net.minestom.server.ServerProcess;
import net.minestom.server.ServerProcessImpl;
import net.minestom.server.advancements.AdvancementManager;
import net.minestom.server.adventure.bossbar.BossBarManager;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.command.CommandManager;
import net.minestom.server.dialog.Dialog;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariant;
import net.minestom.server.entity.metadata.other.PaintingVariant;
import net.minestom.server.event.GlobalEventHandler;
import net.minestom.server.exception.ExceptionManager;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.extras.bungee.BungeeCordProxy;
import net.minestom.server.extras.velocity.VelocityProxy;
import net.minestom.server.instance.InstanceManager;
import net.minestom.server.instance.block.BlockManager;
import net.minestom.server.instance.block.banner.BannerPattern;
import net.minestom.server.instance.block.jukebox.JukeboxSong;
import net.minestom.server.item.armor.TrimMaterial;
import net.minestom.server.item.armor.TrimPattern;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.item.enchant.EntityEffect;
import net.minestom.server.item.enchant.LevelBasedValue;
import net.minestom.server.item.enchant.LocationEffect;
import net.minestom.server.item.enchant.ValueEffect;
import net.minestom.server.item.instrument.Instrument;
import net.minestom.server.listener.manager.PacketListenerManager;
import net.minestom.server.message.ChatType;
import net.minestom.server.monitoring.BenchmarkManager;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.packet.PacketParser;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.server.common.PluginMessagePacket;
import net.minestom.server.network.packet.server.play.ServerDifficultyPacket;
import net.minestom.server.network.socket.Server;
import net.minestom.server.recipe.RecipeManager;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.scoreboard.TeamManager;
import net.minestom.server.thread.TickSchedulerThread;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.utils.PacketSendingUtils;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.Difficulty;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.UnknownNullability;

public final class MinecraftServer
implements MinecraftConstants {
    public static final ComponentLogger LOGGER = ComponentLogger.logger(MinecraftServer.class);
    public static final String THREAD_NAME_BENCHMARK = "Ms-Benchmark";
    public static final String THREAD_NAME_TICK_SCHEDULER = "Ms-TickScheduler";
    public static final String THREAD_NAME_TICK = "Ms-Tick";
    @Deprecated
    public static final int TICK_PER_SECOND = ServerFlag.SERVER_TICKS_PER_SECOND;
    public static final int TICK_MS = 1000 / TICK_PER_SECOND;
    private static volatile @UnknownNullability ServerProcess serverProcess;
    private static int compressionThreshold;
    private static String brandName;
    private static Difficulty difficulty;

    public static MinecraftServer init(Auth auth) {
        MinecraftServer.updateProcess(auth);
        return new MinecraftServer();
    }

    public static MinecraftServer init() {
        return MinecraftServer.init(MinecraftServer.defaultAuth());
    }

    @ApiStatus.Internal
    public static ServerProcess updateProcess(Auth auth) {
        ServerProcessImpl process = new ServerProcessImpl(auth);
        serverProcess = process;
        return process;
    }

    @ApiStatus.Internal
    public static ServerProcess updateProcess() {
        return MinecraftServer.updateProcess(MinecraftServer.defaultAuth());
    }

    private static Auth defaultAuth() {
        if (MojangAuth.isEnabled()) {
            return new Auth.Online(MojangAuth.getKeyPair());
        }
        if (VelocityProxy.isEnabled()) {
            return new Auth.Velocity(VelocityProxy.getKey());
        }
        if (BungeeCordProxy.isEnabled()) {
            return new Auth.Bungee(BungeeCordProxy.getBungeeGuardTokens());
        }
        return new Auth.Offline();
    }

    public static String getBrandName() {
        return brandName;
    }

    public static void setBrandName(String brandName) {
        MinecraftServer.brandName = brandName;
        PacketSendingUtils.broadcastPlayPacket(PluginMessagePacket.brandPacket(brandName));
    }

    public static Difficulty getDifficulty() {
        return difficulty;
    }

    public static void setDifficulty(Difficulty difficulty) {
        MinecraftServer.difficulty = difficulty;
        PacketSendingUtils.broadcastPlayPacket(new ServerDifficultyPacket(difficulty, true));
    }

    public static @UnknownNullability ServerProcess process() {
        return serverProcess;
    }

    public static GlobalEventHandler getGlobalEventHandler() {
        return serverProcess.eventHandler();
    }

    public static PacketListenerManager getPacketListenerManager() {
        return serverProcess.packetListener();
    }

    public static InstanceManager getInstanceManager() {
        return serverProcess.instance();
    }

    public static BlockManager getBlockManager() {
        return serverProcess.block();
    }

    public static CommandManager getCommandManager() {
        return serverProcess.command();
    }

    public static RecipeManager getRecipeManager() {
        return serverProcess.recipe();
    }

    public static TeamManager getTeamManager() {
        return serverProcess.team();
    }

    public static SchedulerManager getSchedulerManager() {
        return serverProcess.scheduler();
    }

    public static BenchmarkManager getBenchmarkManager() {
        return serverProcess.benchmark();
    }

    public static ExceptionManager getExceptionManager() {
        return serverProcess.exception();
    }

    public static ConnectionManager getConnectionManager() {
        return serverProcess.connection();
    }

    public static BossBarManager getBossBarManager() {
        return serverProcess.bossBar();
    }

    public static PacketParser<ClientPacket> getPacketParser() {
        return serverProcess.packetParser();
    }

    public static boolean isStarted() {
        return serverProcess.isAlive();
    }

    public static boolean isStopping() {
        return !MinecraftServer.isStarted();
    }

    @Deprecated
    public static int getChunkViewDistance() {
        return ServerFlag.CHUNK_VIEW_DISTANCE;
    }

    @Deprecated
    public static int getEntityViewDistance() {
        return ServerFlag.ENTITY_VIEW_DISTANCE;
    }

    public static int getCompressionThreshold() {
        return compressionThreshold;
    }

    public static void setCompressionThreshold(int compressionThreshold) {
        Check.stateCondition(serverProcess != null && serverProcess.isAlive(), "The compression threshold cannot be changed after the server has been started.");
        MinecraftServer.compressionThreshold = compressionThreshold;
    }

    public static AdvancementManager getAdvancementManager() {
        return serverProcess.advancement();
    }

    public static DynamicRegistry<ChatType> getChatTypeRegistry() {
        return serverProcess.chatType();
    }

    public static DynamicRegistry<Dialog> getDialogRegistry() {
        return serverProcess.dialog();
    }

    public static DynamicRegistry<DimensionType> getDimensionTypeRegistry() {
        return serverProcess.dimensionType();
    }

    public static DynamicRegistry<Biome> getBiomeRegistry() {
        return serverProcess.biome();
    }

    public static DynamicRegistry<DamageType> getDamageTypeRegistry() {
        return serverProcess.damageType();
    }

    public static DynamicRegistry<TrimMaterial> getTrimMaterialRegistry() {
        return serverProcess.trimMaterial();
    }

    public static DynamicRegistry<TrimPattern> getTrimPatternRegistry() {
        return serverProcess.trimPattern();
    }

    public static DynamicRegistry<BannerPattern> getBannerPatternRegistry() {
        return serverProcess.bannerPattern();
    }

    public static DynamicRegistry<WolfVariant> getWolfVariantRegistry() {
        return serverProcess.wolfVariant();
    }

    public static DynamicRegistry<Enchantment> getEnchantmentRegistry() {
        return serverProcess.enchantment();
    }

    public static DynamicRegistry<PaintingVariant> getPaintingVariantRegistry() {
        return serverProcess.paintingVariant();
    }

    public static DynamicRegistry<JukeboxSong> getJukeboxSongRegistry() {
        return serverProcess.jukeboxSong();
    }

    public static DynamicRegistry<Instrument> getInstrumentRegistry() {
        return serverProcess.instrument();
    }

    public static DynamicRegistry<StructCodec<? extends LevelBasedValue>> enchantmentLevelBasedValues() {
        return MinecraftServer.process().enchantmentLevelBasedValues();
    }

    public static DynamicRegistry<StructCodec<? extends ValueEffect>> enchantmentValueEffects() {
        return MinecraftServer.process().enchantmentValueEffects();
    }

    public static DynamicRegistry<StructCodec<? extends EntityEffect>> enchantmentEntityEffects() {
        return MinecraftServer.process().enchantmentEntityEffects();
    }

    public static DynamicRegistry<StructCodec<? extends LocationEffect>> enchantmentLocationEffects() {
        return MinecraftServer.process().enchantmentLocationEffects();
    }

    public static Server getServer() {
        return serverProcess.server();
    }

    public void start(SocketAddress address) {
        serverProcess.start(address);
        serverProcess.dispatcher().start();
        new TickSchedulerThread(serverProcess).start();
    }

    public void start(String address, int port) {
        this.start(new InetSocketAddress(address, port));
    }

    public static void stopCleanly() {
        serverProcess.stop();
    }

    static {
        compressionThreshold = 256;
        brandName = "Minestom";
        difficulty = Difficulty.NORMAL;
    }
}

