/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.text.Component;
import net.minestom.server.Auth;
import net.minestom.server.Git;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.ServerProcess;
import net.minestom.server.advancements.AdvancementManager;
import net.minestom.server.adventure.bossbar.BossBarManager;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.command.CommandManager;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponents;
import net.minestom.server.dialog.Dialog;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.metadata.animal.ChickenVariant;
import net.minestom.server.entity.metadata.animal.CowVariant;
import net.minestom.server.entity.metadata.animal.FrogVariant;
import net.minestom.server.entity.metadata.animal.PigVariant;
import net.minestom.server.entity.metadata.animal.tameable.CatVariant;
import net.minestom.server.entity.metadata.animal.tameable.WolfSoundVariant;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariant;
import net.minestom.server.entity.metadata.other.PaintingVariant;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.GlobalEventHandler;
import net.minestom.server.event.server.ServerTickMonitorEvent;
import net.minestom.server.exception.ExceptionManager;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceManager;
import net.minestom.server.instance.block.BlockManager;
import net.minestom.server.instance.block.banner.BannerPattern;
import net.minestom.server.instance.block.jukebox.JukeboxSong;
import net.minestom.server.item.armor.TrimMaterial;
import net.minestom.server.item.armor.TrimPattern;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.item.enchant.EntityEffect;
import net.minestom.server.item.enchant.LevelBasedValue;
import net.minestom.server.item.enchant.LocationEffect;
import net.minestom.server.item.enchant.ValueEffect;
import net.minestom.server.item.instrument.Instrument;
import net.minestom.server.listener.manager.PacketListenerManager;
import net.minestom.server.message.ChatType;
import net.minestom.server.monitoring.BenchmarkManager;
import net.minestom.server.monitoring.EventsJFR;
import net.minestom.server.monitoring.TickMonitor;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.packet.PacketParser;
import net.minestom.server.network.packet.PacketVanilla;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.socket.Server;
import net.minestom.server.recipe.RecipeManager;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.scoreboard.TeamManager;
import net.minestom.server.snapshot.EntitySnapshot;
import net.minestom.server.snapshot.ServerSnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.thread.ThreadDispatcher;
import net.minestom.server.thread.ThreadProvider;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.utils.PacketViewableUtils;
import net.minestom.server.utils.collection.MappedCollection;
import net.minestom.server.utils.time.Tick;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biome.Biome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerProcessImpl
implements ServerProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerProcessImpl.class);
    private final Auth auth;
    private final ExceptionManager exception;
    private final DynamicRegistry<StructCodec<? extends LevelBasedValue>> enchantmentLevelBasedValues;
    private final DynamicRegistry<StructCodec<? extends ValueEffect>> enchantmentValueEffects;
    private final DynamicRegistry<StructCodec<? extends EntityEffect>> enchantmentEntityEffects;
    private final DynamicRegistry<StructCodec<? extends LocationEffect>> enchantmentLocationEffects;
    private final DynamicRegistry<ChatType> chatType;
    private final DynamicRegistry<Dialog> dialog;
    private final DynamicRegistry<DimensionType> dimensionType;
    private final DynamicRegistry<Biome> biome;
    private final DynamicRegistry<DamageType> damageType;
    private final DynamicRegistry<TrimMaterial> trimMaterial;
    private final DynamicRegistry<TrimPattern> trimPattern;
    private final DynamicRegistry<BannerPattern> bannerPattern;
    private final DynamicRegistry<Enchantment> enchantment;
    private final DynamicRegistry<PaintingVariant> paintingVariant;
    private final DynamicRegistry<JukeboxSong> jukeboxSong;
    private final DynamicRegistry<Instrument> instrument;
    private final DynamicRegistry<WolfVariant> wolfVariant;
    private final DynamicRegistry<WolfSoundVariant> wolfSoundVariant;
    private final DynamicRegistry<CatVariant> catVariant;
    private final DynamicRegistry<ChickenVariant> chickenVariant;
    private final DynamicRegistry<CowVariant> cowVariant;
    private final DynamicRegistry<FrogVariant> frogVariant;
    private final DynamicRegistry<PigVariant> pigVariant;
    private final ConnectionManager connection;
    private final PacketListenerManager packetListener;
    private final PacketParser<ClientPacket> packetParser;
    private final InstanceManager instance;
    private final BlockManager block;
    private final CommandManager command;
    private final RecipeManager recipe;
    private final TeamManager team;
    private final GlobalEventHandler eventHandler;
    private final SchedulerManager scheduler;
    private final BenchmarkManager benchmark;
    private final AdvancementManager advancement;
    private final BossBarManager bossBar;
    private final Server server;
    private final ThreadDispatcher<Chunk, Entity> dispatcher;
    private final ServerProcess.Ticker ticker;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();

    public ServerProcessImpl(Auth auth) {
        this.auth = auth;
        this.exception = new ExceptionManager();
        DataComponent<Component> ignoredForInit = DataComponents.ITEM_NAME;
        this.enchantmentLevelBasedValues = LevelBasedValue.createDefaultRegistry();
        this.enchantmentValueEffects = ValueEffect.createDefaultRegistry();
        this.enchantmentEntityEffects = EntityEffect.createDefaultRegistry();
        this.enchantmentLocationEffects = LocationEffect.createDefaultRegistry();
        this.chatType = ChatType.createDefaultRegistry();
        this.dialog = Dialog.createDefaultRegistry(this);
        this.dimensionType = DimensionType.createDefaultRegistry();
        this.biome = Biome.createDefaultRegistry();
        this.damageType = DamageType.createDefaultRegistry();
        this.trimMaterial = TrimMaterial.createDefaultRegistry();
        this.trimPattern = TrimPattern.createDefaultRegistry();
        this.bannerPattern = BannerPattern.createDefaultRegistry();
        this.enchantment = Enchantment.createDefaultRegistry(this);
        this.paintingVariant = PaintingVariant.createDefaultRegistry();
        this.jukeboxSong = JukeboxSong.createDefaultRegistry();
        this.instrument = Instrument.createDefaultRegistry();
        this.wolfVariant = WolfVariant.createDefaultRegistry();
        this.wolfSoundVariant = WolfSoundVariant.createDefaultRegistry();
        this.catVariant = CatVariant.createDefaultRegistry();
        this.chickenVariant = ChickenVariant.createDefaultRegistry();
        this.cowVariant = CowVariant.createDefaultRegistry();
        this.frogVariant = FrogVariant.createDefaultRegistry();
        this.pigVariant = PigVariant.createDefaultRegistry();
        this.connection = new ConnectionManager();
        this.packetListener = new PacketListenerManager();
        this.packetParser = PacketVanilla.CLIENT_PACKET_PARSER;
        this.instance = new InstanceManager(this);
        this.block = new BlockManager();
        this.command = new CommandManager();
        this.recipe = new RecipeManager();
        this.team = new TeamManager();
        this.eventHandler = new GlobalEventHandler();
        this.scheduler = new SchedulerManager();
        this.benchmark = new BenchmarkManager();
        this.advancement = new AdvancementManager();
        this.bossBar = new BossBarManager();
        this.server = new Server(this.packetParser);
        this.dispatcher = ThreadDispatcher.dispatcher(ThreadProvider.counter(), ServerFlag.DISPATCHER_THREADS);
        this.ticker = new TickerImpl(this);
    }

    @Override
    public Auth auth() {
        return this.auth;
    }

    @Override
    public ExceptionManager exception() {
        return this.exception;
    }

    @Override
    public DynamicRegistry<Dialog> dialog() {
        return this.dialog;
    }

    @Override
    public DynamicRegistry<DamageType> damageType() {
        return this.damageType;
    }

    @Override
    public DynamicRegistry<TrimMaterial> trimMaterial() {
        return this.trimMaterial;
    }

    @Override
    public DynamicRegistry<TrimPattern> trimPattern() {
        return this.trimPattern;
    }

    @Override
    public DynamicRegistry<BannerPattern> bannerPattern() {
        return this.bannerPattern;
    }

    @Override
    public DynamicRegistry<Enchantment> enchantment() {
        return this.enchantment;
    }

    @Override
    public DynamicRegistry<PaintingVariant> paintingVariant() {
        return this.paintingVariant;
    }

    @Override
    public DynamicRegistry<JukeboxSong> jukeboxSong() {
        return this.jukeboxSong;
    }

    @Override
    public DynamicRegistry<Instrument> instrument() {
        return this.instrument;
    }

    @Override
    public DynamicRegistry<WolfVariant> wolfVariant() {
        return this.wolfVariant;
    }

    @Override
    public DynamicRegistry<WolfSoundVariant> wolfSoundVariant() {
        return this.wolfSoundVariant;
    }

    @Override
    public DynamicRegistry<CatVariant> catVariant() {
        return this.catVariant;
    }

    @Override
    public DynamicRegistry<ChickenVariant> chickenVariant() {
        return this.chickenVariant;
    }

    @Override
    public DynamicRegistry<CowVariant> cowVariant() {
        return this.cowVariant;
    }

    @Override
    public DynamicRegistry<FrogVariant> frogVariant() {
        return this.frogVariant;
    }

    @Override
    public DynamicRegistry<PigVariant> pigVariant() {
        return this.pigVariant;
    }

    @Override
    public DynamicRegistry<StructCodec<? extends LevelBasedValue>> enchantmentLevelBasedValues() {
        return this.enchantmentLevelBasedValues;
    }

    @Override
    public DynamicRegistry<StructCodec<? extends ValueEffect>> enchantmentValueEffects() {
        return this.enchantmentValueEffects;
    }

    @Override
    public DynamicRegistry<StructCodec<? extends EntityEffect>> enchantmentEntityEffects() {
        return this.enchantmentEntityEffects;
    }

    @Override
    public DynamicRegistry<StructCodec<? extends LocationEffect>> enchantmentLocationEffects() {
        return this.enchantmentLocationEffects;
    }

    @Override
    public ConnectionManager connection() {
        return this.connection;
    }

    @Override
    public InstanceManager instance() {
        return this.instance;
    }

    @Override
    public BlockManager block() {
        return this.block;
    }

    @Override
    public CommandManager command() {
        return this.command;
    }

    @Override
    public RecipeManager recipe() {
        return this.recipe;
    }

    @Override
    public TeamManager team() {
        return this.team;
    }

    @Override
    public GlobalEventHandler eventHandler() {
        return this.eventHandler;
    }

    @Override
    public SchedulerManager scheduler() {
        return this.scheduler;
    }

    @Override
    public BenchmarkManager benchmark() {
        return this.benchmark;
    }

    @Override
    public AdvancementManager advancement() {
        return this.advancement;
    }

    @Override
    public BossBarManager bossBar() {
        return this.bossBar;
    }

    @Override
    public DynamicRegistry<ChatType> chatType() {
        return this.chatType;
    }

    @Override
    public DynamicRegistry<DimensionType> dimensionType() {
        return this.dimensionType;
    }

    @Override
    public DynamicRegistry<Biome> biome() {
        return this.biome;
    }

    @Override
    public PacketListenerManager packetListener() {
        return this.packetListener;
    }

    @Override
    public PacketParser<ClientPacket> packetParser() {
        return this.packetParser;
    }

    @Override
    public Server server() {
        return this.server;
    }

    @Override
    public ThreadDispatcher<Chunk, Entity> dispatcher() {
        return this.dispatcher;
    }

    @Override
    public ServerProcess.Ticker ticker() {
        return this.ticker;
    }

    @Override
    public void start(SocketAddress socketAddress) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Server already started");
        }
        String brand = MinecraftServer.getBrandName();
        LOGGER.info("Starting {} ({}) server.", (Object)brand, (Object)Git.version());
        Auth auth = this.auth;
        Objects.requireNonNull(auth);
        Auth auth2 = auth;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Auth.Offline.class, Auth.Online.class, Auth.Velocity.class, Auth.Bungee.class}, (Auth)auth2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Auth.Offline ignored = (Auth.Offline)auth2;
                LOGGER.info("Running in offline mode. Beware that this is not secure and players can impersonate each other.");
                break;
            }
            case 1: {
                Auth.Online ignored = (Auth.Online)auth2;
                LOGGER.info("Running in online mode with Mojang's authentication.");
                break;
            }
            case 2: {
                Auth.Velocity ignored = (Auth.Velocity)auth2;
                LOGGER.info("Running in Velocity mode with modern IP forwarding.");
                break;
            }
            case 3: {
                Auth.Bungee bungee = (Auth.Bungee)auth2;
                if (bungee.guard()) {
                    LOGGER.info("Running in BungeeCord mode, using legacy IP forwarding with Guard enabled.");
                    break;
                }
                LOGGER.info("Running in BungeeCord mode without BungeeGuard. Be sure to configure your firewall to prevent direct connections.");
            }
        }
        try {
            this.server.init(socketAddress);
        }
        catch (IOException e) {
            this.exception.handleException(e);
            throw new RuntimeException(e);
        }
        this.server.start();
        LOGGER.info("{} server started successfully.", (Object)brand);
        if (ServerFlag.SHUTDOWN_ON_SIGNAL) {
            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        }
    }

    @Override
    public void stop() {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        String brand = MinecraftServer.getBrandName();
        LOGGER.info("Stopping {} server.", (Object)brand);
        this.scheduler.shutdown();
        this.connection.shutdown();
        this.server.stop();
        LOGGER.info("Shutting down all thread pools.");
        this.benchmark.disable();
        this.dispatcher.shutdown();
        LOGGER.info("{} server stopped successfully.", (Object)brand);
    }

    @Override
    public boolean isAlive() {
        return this.started.get() && !this.stopped.get();
    }

    @Override
    public ServerSnapshot updateSnapshot(SnapshotUpdater updater) {
        ArrayList instanceRefs = new ArrayList();
        Int2ObjectOpenHashMap<AtomicReference<EntitySnapshot>> entityRefs = new Int2ObjectOpenHashMap<AtomicReference<EntitySnapshot>>();
        for (Instance instance : this.instance.getInstances()) {
            instanceRefs.add(updater.reference(instance));
            for (Entity entity : instance.getEntities()) {
                entityRefs.put(entity.getEntityId(), (AtomicReference<EntitySnapshot>)updater.reference(entity));
            }
        }
        return new SnapshotImpl.Server(MappedCollection.plainReferences(instanceRefs), entityRefs);
    }

    private final class TickerImpl
    implements ServerProcess.Ticker {
        final /* synthetic */ ServerProcessImpl this$0;

        private TickerImpl(ServerProcessImpl serverProcessImpl) {
            ServerProcessImpl serverProcessImpl2 = serverProcessImpl;
            Objects.requireNonNull(serverProcessImpl2);
            this.this$0 = serverProcessImpl2;
        }

        @Override
        public void tick(long nanoTime) {
            EventsJFR.EventMarker serverTickEvent = EventsJFR.newServerTick();
            serverTickEvent.begin();
            this.this$0.scheduler().processTick();
            this.this$0.connection().tick(nanoTime);
            this.serverTick(nanoTime);
            this.this$0.scheduler().processTickEnd();
            PacketViewableUtils.flush();
            double acquisitionTimeMs = (double)Acquirable.resetAcquiringTime() / 1000000.0;
            double tickTimeMs = (double)(System.nanoTime() - nanoTime) / 1000000.0;
            TickMonitor tickMonitor = new TickMonitor(tickTimeMs, acquisitionTimeMs);
            EventDispatcher.call(new ServerTickMonitorEvent(tickMonitor));
            serverTickEvent.commit();
        }

        private void serverTick(long nanoStart) {
            long milliStart = TimeUnit.NANOSECONDS.toMillis(nanoStart);
            for (Instance instance : this.this$0.instance().getInstances()) {
                try {
                    instance.tick(milliStart);
                }
                catch (Exception e) {
                    this.this$0.exception().handleException(e);
                }
            }
            this.this$0.dispatcher().updateAndAwait(nanoStart);
            long tickDuration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nanoStart);
            long remainingTickDuration = Tick.SERVER_TICKS.getDuration().toNanos() - tickDuration;
            this.this$0.dispatcher().refreshThreads(remainingTickDuration);
        }
    }
}

