/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.utils.PacketSendingUtils;

public interface Viewable {
    public boolean addViewer(Player var1);

    public boolean removeViewer(Player var1);

    public Set<Player> getViewers();

    default public boolean isViewer(Player player) {
        return this.getViewers().contains(player);
    }

    default public void sendPacketToViewers(SendablePacket packet) {
        if (packet instanceof ServerPacket) {
            ServerPacket serverPacket = (ServerPacket)packet;
            PacketSendingUtils.sendGroupedPacket(this.getViewers(), serverPacket);
        } else {
            this.getViewers().forEach(player -> player.sendPacket(packet));
        }
    }

    default public void sendPacketsToViewers(Collection<SendablePacket> packets) {
        packets.forEach(this::sendPacketToViewers);
    }

    default public void sendPacketsToViewers(SendablePacket ... packets) {
        this.sendPacketsToViewers(List.of(packets));
    }

    default public void sendPacketToViewersAndSelf(SendablePacket packet) {
        this.sendPacketToViewers(packet);
    }

    default public Audience getViewersAsAudience() {
        return PacketGroupingAudience.of(this.getViewers());
    }

    default public Iterable<? extends Audience> getViewersAsAudiences() {
        return this.getViewers();
    }
}

