/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.audience;

import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.audience.AudienceProvider;
import net.minestom.server.adventure.audience.AudienceRegistry;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.adventure.audience.SingleAudienceProvider;
import net.minestom.server.entity.Player;

public class Audiences {
    private static final SingleAudienceProvider audience = new SingleAudienceProvider();

    public static AudienceProvider<Audience> single() {
        return audience;
    }

    public static AudienceProvider<Iterable<? extends Audience>> iterable() {
        return Audiences.audience.collection;
    }

    public static Audience all() {
        return Audience.audience(Audiences.audience.server, audience.customs());
    }

    public static Audience players() {
        return Audiences.audience.players;
    }

    public static Audience players(Predicate<Player> filter) {
        return PacketGroupingAudience.of(MinecraftServer.getConnectionManager().getOnlinePlayers().stream().filter(filter).toList());
    }

    public static Audience console() {
        return MinecraftServer.getCommandManager().getConsoleSender();
    }

    public static Audience server() {
        return Audiences.audience.server;
    }

    public static Audience customs() {
        return Audience.audience((Iterable<? extends Audience>)audience.iterable().customs());
    }

    public static Audience custom(Keyed keyed) {
        return Audiences.custom(keyed.key());
    }

    public static Audience custom(Key key) {
        return Audience.audience((Iterable<? extends Audience>)audience.iterable().custom(key));
    }

    public static Audience custom(Keyed keyed, Predicate<Audience> filter) {
        return Audiences.custom(keyed.key(), filter);
    }

    public static Audience custom(Key key, Predicate<Audience> filter) {
        return Audience.audience((Iterable<? extends Audience>)audience.iterable().custom(key, (Predicate)filter));
    }

    public static Audience customs(Predicate<Audience> filter) {
        return Audience.audience((Iterable<? extends Audience>)audience.iterable().customs((Predicate)filter));
    }

    public static Audience all(Predicate<Audience> filter) {
        return Audience.audience((Iterable<? extends Audience>)audience.iterable().all((Predicate)filter));
    }

    public static AudienceRegistry registry() {
        return audience.iterable().registry();
    }
}

