/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.audience;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.audience.AudienceProvider;
import net.minestom.server.adventure.audience.AudienceRegistry;
import net.minestom.server.command.ConsoleSender;
import net.minestom.server.entity.Player;

class IterableAudienceProvider
implements AudienceProvider<Iterable<? extends Audience>> {
    private final List<ConsoleSender> console = List.of(MinecraftServer.getCommandManager().getConsoleSender());
    private final AudienceRegistry registry = new AudienceRegistry(new ConcurrentHashMap<Key, Collection<Audience>>(), CopyOnWriteArrayList::new);

    protected IterableAudienceProvider() {
    }

    @Override
    public Iterable<? extends Audience> all() {
        ArrayList all = new ArrayList();
        this.players().forEach(all::add);
        this.console().forEach(all::add);
        this.customs().forEach(all::add);
        return all;
    }

    @Override
    public Iterable<? extends Audience> players() {
        return MinecraftServer.getConnectionManager().getOnlinePlayers();
    }

    @Override
    public Iterable<? extends Audience> players(Predicate<Player> filter) {
        return MinecraftServer.getConnectionManager().getOnlinePlayers().stream().filter(filter).toList();
    }

    @Override
    public Iterable<? extends Audience> console() {
        return this.console;
    }

    @Override
    public Iterable<? extends Audience> server() {
        ArrayList all = new ArrayList();
        this.players().forEach(all::add);
        this.console().forEach(all::add);
        return all;
    }

    @Override
    public Iterable<? extends Audience> customs() {
        return this.registry.all();
    }

    @Override
    public Iterable<? extends Audience> custom(Key key) {
        return this.registry.of(key);
    }

    @Override
    public Iterable<? extends Audience> custom(Key key, Predicate<Audience> filter) {
        return StreamSupport.stream(this.registry.of(key).spliterator(), false).filter(filter).toList();
    }

    @Override
    public Iterable<? extends Audience> customs(Predicate<Audience> filter) {
        return this.registry.of(filter);
    }

    @Override
    public Iterable<? extends Audience> all(Predicate<Audience> filter) {
        return StreamSupport.stream(this.all().spliterator(), false).filter(filter).toList();
    }

    @Override
    public AudienceRegistry registry() {
        return this.registry;
    }
}

