/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.audience;

import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.audience.AudienceProvider;
import net.minestom.server.adventure.audience.AudienceRegistry;
import net.minestom.server.adventure.audience.IterableAudienceProvider;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.entity.Player;

class SingleAudienceProvider
implements AudienceProvider<Audience> {
    protected final IterableAudienceProvider collection = new IterableAudienceProvider();
    protected final Audience players = PacketGroupingAudience.of(MinecraftServer.getConnectionManager().getOnlinePlayers());
    protected final Audience server = Audience.audience(this.players, MinecraftServer.getCommandManager().getConsoleSender());

    protected SingleAudienceProvider() {
    }

    public IterableAudienceProvider iterable() {
        return this.collection;
    }

    @Override
    public Audience all() {
        return Audience.audience(this.server, this.customs());
    }

    @Override
    public Audience players() {
        return this.players;
    }

    @Override
    public Audience players(Predicate<Player> filter) {
        return PacketGroupingAudience.of(MinecraftServer.getConnectionManager().getOnlinePlayers().stream().filter(filter).toList());
    }

    @Override
    public Audience console() {
        return MinecraftServer.getCommandManager().getConsoleSender();
    }

    @Override
    public Audience server() {
        return this.server;
    }

    @Override
    public Audience customs() {
        return Audience.audience((Iterable<? extends Audience>)this.iterable().customs());
    }

    @Override
    public Audience custom(Key key) {
        return Audience.audience((Iterable<? extends Audience>)this.iterable().custom(key));
    }

    @Override
    public Audience custom(Key key, Predicate<Audience> filter) {
        return Audience.audience((Iterable<? extends Audience>)this.iterable().custom(key, (Predicate)filter));
    }

    @Override
    public Audience customs(Predicate<Audience> filter) {
        return Audience.audience((Iterable<? extends Audience>)this.iterable().customs((Predicate)filter));
    }

    @Override
    public Audience all(Predicate<Audience> filter) {
        return Audience.audience((Iterable<? extends Audience>)this.iterable().all((Predicate)filter));
    }

    @Override
    public AudienceRegistry registry() {
        return this.iterable().registry();
    }
}

