/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import net.minestom.server.codec.CodecImpl;
import net.minestom.server.codec.ComponentCodecs;
import net.minestom.server.codec.Decoder;
import net.minestom.server.codec.Encoder;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.coordinate.Point;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.Either;
import net.minestom.server.utils.ThrowingFunction;
import net.minestom.server.utils.UUIDUtils;
import net.minestom.server.utils.Unit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public interface Codec<T>
extends Encoder<T>,
Decoder<T> {
    public static final Codec<RawValue> RAW_VALUE = new CodecImpl.RawValueCodecImpl();
    public static final Codec<Unit> UNIT = StructCodec.struct(Unit.INSTANCE);
    public static final Codec<Boolean> BOOLEAN = new CodecImpl.PrimitiveImpl<Boolean>(Transcoder::createBoolean, Transcoder::getBoolean);
    public static final Codec<Byte> BYTE = new CodecImpl.PrimitiveImpl<Byte>(Transcoder::createByte, Transcoder::getByte);
    public static final Codec<Short> SHORT = new CodecImpl.PrimitiveImpl<Short>(Transcoder::createShort, Transcoder::getShort);
    public static final Codec<Integer> INT = new CodecImpl.PrimitiveImpl<Integer>(Transcoder::createInt, Transcoder::getInt);
    public static final Codec<Long> LONG = new CodecImpl.PrimitiveImpl<Long>(Transcoder::createLong, Transcoder::getLong);
    public static final Codec<Float> FLOAT = new CodecImpl.PrimitiveImpl<Float>(Transcoder::createFloat, Transcoder::getFloat);
    public static final Codec<Double> DOUBLE = new CodecImpl.PrimitiveImpl<Double>(Transcoder::createDouble, Transcoder::getDouble);
    public static final Codec<String> STRING = new CodecImpl.PrimitiveImpl<String>(Transcoder::createString, Transcoder::getString);
    public static final Codec<Key> KEY = STRING.transform(Key::key, Key::asString);
    public static final Codec<byte[]> BYTE_ARRAY = new CodecImpl.PrimitiveImpl<byte[]>(Transcoder::createByteArray, Transcoder::getByteArray);
    public static final Codec<int[]> INT_ARRAY = new CodecImpl.PrimitiveImpl<int[]>(Transcoder::createIntArray, Transcoder::getIntArray);
    public static final Codec<long[]> LONG_ARRAY = new CodecImpl.PrimitiveImpl<long[]>(Transcoder::createLongArray, Transcoder::getLongArray);
    public static final Codec<UUID> UUID = INT_ARRAY.transform(UUIDUtils::intArrayToUuid, UUIDUtils::uuidToIntArray);
    public static final Codec<UUID> UUID_STRING = STRING.transform(UUID::fromString, UUID::toString);
    public static final Codec<UUID> UUID_COERCED = UUID.orElse(UUID_STRING);
    public static final Codec<Component> COMPONENT = ComponentCodecs.COMPONENT;
    public static final Codec<Style> COMPONENT_STYLE = ComponentCodecs.STYLE;
    public static final Codec<Point> BLOCK_POSITION = new CodecImpl.BlockPositionImpl();
    public static final Codec<Point> VECTOR3D = new CodecImpl.Vector3DImpl();
    public static final Codec<BinaryTag> NBT = RAW_VALUE.transform(value -> value.convertTo(Transcoder.NBT).orElseThrow(), value -> RawValue.of(Transcoder.NBT, value));
    public static final Codec<CompoundBinaryTag> NBT_COMPOUND = NBT.transform(value -> {
        if (!(value instanceof CompoundBinaryTag)) {
            throw new IllegalArgumentException("Not a compound: " + String.valueOf(value));
        }
        CompoundBinaryTag compound = (CompoundBinaryTag)value;
        return compound;
    }, compound -> compound);

    @Contract(pure=true, value="_ -> new")
    public static <E extends Enum<E>> Codec<E> Enum(Class<E> enumClass) {
        Objects.requireNonNull(enumClass, "Enum class cannot be null");
        return STRING.transform(value -> Enum.valueOf(enumClass, value.toUpperCase(Locale.ROOT)), value -> value.name().toLowerCase(Locale.ROOT));
    }

    @Contract(pure=true, value="_ -> new")
    public static <T> Codec<T> Recursive(Function<Codec<T>, Codec<T>> func) {
        return new CodecImpl.RecursiveImpl<T>(func).delegate;
    }

    @Contract(pure=true, value="_ -> new")
    public static <T> Codec<T> ForwardRef(Supplier<Codec<T>> supplier) {
        return new CodecImpl.ForwardRefImpl<T>(supplier);
    }

    @Deprecated
    @Contract(pure=true, value="_, _, _ -> new")
    public static <T> StructCodec<T> RegistryTaggedUnion(Registry<StructCodec<? extends T>> registry, Function<T, StructCodec<? extends T>> serializerGetter, String key) {
        return Codec.RegistryTaggedUnion(key, registry, serializerGetter);
    }

    @Deprecated
    @Contract(pure=true, value="_, _, _ -> new")
    public static <T> StructCodec<T> RegistryTaggedUnion(Registries.Selector<StructCodec<? extends T>> registrySelector, Function<T, StructCodec<? extends T>> serializerGetter, String key) {
        return Codec.RegistryTaggedUnion(key, registrySelector, serializerGetter);
    }

    @Contract(pure=true, value="_, _ -> new")
    public static <T> StructCodec<T> RegistryTaggedUnion(Registry<StructCodec<? extends T>> registry, Function<T, StructCodec<? extends T>> serializerGetter) {
        return Codec.RegistryTaggedUnion("type", registry, serializerGetter);
    }

    @Contract(pure=true, value="_, _, _ -> new")
    public static <T> StructCodec<T> RegistryTaggedUnion(String key, Registry<StructCodec<? extends T>> registry, Function<T, StructCodec<? extends T>> serializerGetter) {
        Objects.requireNonNull(registry, "registry");
        return Codec.RegistryTaggedUnion(key, (Registries ignored) -> registry, serializerGetter);
    }

    @Contract(pure=true, value="_, _ -> new")
    public static <T> StructCodec<T> RegistryTaggedUnion(Registries.Selector<StructCodec<? extends T>> registrySelector, Function<T, StructCodec<? extends T>> serializerGetter) {
        return new CodecImpl.RegistryTaggedUnionImpl<T>("type", registrySelector, serializerGetter);
    }

    @Contract(pure=true, value="_, _, _ -> new")
    public static <T> StructCodec<T> RegistryTaggedUnion(String key, Registries.Selector<StructCodec<? extends T>> registrySelector, Function<T, StructCodec<? extends T>> serializerGetter) {
        return new CodecImpl.RegistryTaggedUnionImpl<T>(key, registrySelector, serializerGetter);
    }

    @Contract(pure=true, value="_, _ -> new")
    public static <L, R> Codec<Either<L, R>> Either(Codec<L> leftCodec, Codec<R> rightCodec) {
        return new CodecImpl.EitherImpl<L, R>(leftCodec, rightCodec);
    }

    @Contract(pure=true, value="_, _ -> new")
    public static <L, R> StructCodec<Either<L, R>> EitherStruct(StructCodec<L> leftCodec, StructCodec<R> rightCodec) {
        return new CodecImpl.EitherStructImpl<L, R>(leftCodec, rightCodec);
    }

    @Contract(pure=true, value="-> new")
    default public Codec<@Nullable T> optional() {
        return new CodecImpl.OptionalImpl<Object>(this, null);
    }

    @Contract(pure=true, value="_ -> new")
    default public Codec<@UnknownNullability T> optional(T defaultValue) {
        return new CodecImpl.OptionalImpl<T>(this, Objects.requireNonNull(defaultValue, "Default value cannot be null"));
    }

    @Contract(pure=true, value="_, _ -> new")
    default public <S> Codec<S> transform(ThrowingFunction<T, S> to, ThrowingFunction<S, T> from) {
        return new CodecImpl.TransformImpl<T, S>(this, to, from);
    }

    @Contract(pure=true, value="_ -> new")
    default public Codec<@Unmodifiable List<T>> list(int maxSize) {
        return new CodecImpl.ListImpl(this, maxSize);
    }

    @Contract(pure=true, value="-> new")
    default public Codec<@Unmodifiable List<T>> list() {
        return this.list(Integer.MAX_VALUE);
    }

    @Contract(pure=true, value="_ -> new")
    default public Codec<@Unmodifiable @Nullable List<T>> listOrSingle(int maxSize) {
        return this.list(maxSize).orElse(this.transform(it -> it == null ? null : List.of(it), list -> list.isEmpty() ? null : list.getFirst()));
    }

    @Contract(pure=true, value="-> new")
    default public Codec<@Unmodifiable @Nullable List<T>> listOrSingle() {
        return this.listOrSingle(Integer.MAX_VALUE);
    }

    @Contract(pure=true, value="_ -> new")
    default public Codec<@Unmodifiable Set<T>> set(int maxSize) {
        return new CodecImpl.SetImpl(this, maxSize);
    }

    @Contract(pure=true, value="-> new")
    default public Codec<@Unmodifiable Set<T>> set() {
        return this.set(Integer.MAX_VALUE);
    }

    @Contract(pure=true, value="_, _ -> new")
    default public <V> Codec<@Unmodifiable Map<T, V>> mapValue(Codec<V> valueCodec, int maxSize) {
        return new CodecImpl.MapImpl(this, valueCodec, maxSize);
    }

    @Contract(pure=true, value="_ -> new")
    default public <V> Codec<@Unmodifiable Map<T, V>> mapValue(Codec<V> valueCodec) {
        return this.mapValue(valueCodec, Integer.MAX_VALUE);
    }

    @Contract(pure=true, value="_, _ -> new")
    default public <R> StructCodec<R> unionType(Function<T, StructCodec<? extends R>> serializers, Function<R, ? extends T> keyFunc) {
        return this.unionType("type", serializers, keyFunc);
    }

    @Contract(pure=true, value="_, _, _ -> new")
    default public <R> StructCodec<R> unionType(String keyField, Function<T, StructCodec<? extends R>> serializers, Function<R, ? extends T> keyFunc) {
        return new CodecImpl.UnionImpl<T, R>(keyField, this, serializers, keyFunc);
    }

    @Contract(pure=true, value="_ -> new")
    default public Codec<T> orElse(Codec<T> other) {
        return new CodecImpl.OrElseImpl<T>(this, other);
    }

    public static sealed interface RawValue
    permits CodecImpl.RawValueImpl {
        @Contract(pure=true, value="_, _ -> new")
        public static <D> RawValue of(Transcoder<D> coder, D value) {
            return new CodecImpl.RawValueImpl<D>(coder, value);
        }

        public <D> Result<D> convertTo(Transcoder<D> var1);
    }
}

