/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class TranscoderJsonImpl
implements Transcoder<JsonElement> {
    public static final TranscoderJsonImpl INSTANCE = new TranscoderJsonImpl();

    TranscoderJsonImpl() {
    }

    @Override
    public JsonElement createNull() {
        return JsonNull.INSTANCE;
    }

    @Override
    public Result<Boolean> getBoolean(JsonElement value) {
        if (!(value instanceof JsonPrimitive)) {
            return new Result.Error<Boolean>("Not a boolean: " + String.valueOf(value));
        }
        JsonPrimitive primitive = (JsonPrimitive)value;
        return new Result.Ok<Boolean>(primitive.getAsBoolean());
    }

    @Override
    public JsonElement createBoolean(boolean value) {
        return new JsonPrimitive(value);
    }

    @Override
    public Result<Byte> getByte(JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Byte>("Not a byte: " + String.valueOf(value));
        }
        return new Result.Ok<Byte>(primitive.getAsByte());
    }

    @Override
    public JsonElement createByte(byte value) {
        return new JsonPrimitive(value);
    }

    @Override
    public Result<Short> getShort(JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Short>("Not a short: " + String.valueOf(value));
        }
        return new Result.Ok<Short>(primitive.getAsShort());
    }

    @Override
    public JsonElement createShort(short value) {
        return new JsonPrimitive(value);
    }

    @Override
    public Result<Integer> getInt(JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Integer>("Not an int: " + String.valueOf(value));
        }
        return new Result.Ok<Integer>(primitive.getAsInt());
    }

    @Override
    public JsonElement createInt(int value) {
        return new JsonPrimitive(value);
    }

    @Override
    public Result<Long> getLong(JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Long>("Not a long: " + String.valueOf(value));
        }
        return new Result.Ok<Long>(primitive.getAsLong());
    }

    @Override
    public JsonElement createLong(long value) {
        return new JsonPrimitive(value);
    }

    @Override
    public Result<Float> getFloat(JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Float>("Not a float: " + String.valueOf(value));
        }
        return new Result.Ok<Float>(Float.valueOf(primitive.getAsFloat()));
    }

    @Override
    public JsonElement createFloat(float value) {
        return new JsonPrimitive(Float.valueOf(value));
    }

    @Override
    public Result<Double> getDouble(JsonElement value) {
        JsonPrimitive primitive;
        if (!(value instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)value).isNumber()) {
            return new Result.Error<Double>("Not a double: " + String.valueOf(value));
        }
        return new Result.Ok<Double>(primitive.getAsDouble());
    }

    @Override
    public JsonElement createDouble(double value) {
        return new JsonPrimitive(value);
    }

    @Override
    public Result<String> getString(JsonElement value) {
        if (!(value instanceof JsonPrimitive)) {
            return new Result.Error<String>("Not a string: " + String.valueOf(value));
        }
        JsonPrimitive primitive = (JsonPrimitive)value;
        return new Result.Ok<String>(primitive.getAsString());
    }

    @Override
    public JsonElement createString(String value) {
        return new JsonPrimitive(value);
    }

    @Override
    public Result<List<JsonElement>> getList(JsonElement value) {
        if (!(value instanceof JsonArray)) {
            return new Result.Error<List<JsonElement>>("Not a list: " + String.valueOf(value));
        }
        final JsonArray array = (JsonArray)value;
        if (array.isEmpty()) {
            return new Result.Ok<List<JsonElement>>(List.of());
        }
        return new Result.Ok<List<JsonElement>>(new AbstractList<JsonElement>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public JsonElement get(int index) {
                return array.get(index);
            }

            @Override
            public int size() {
                return array.size();
            }
        });
    }

    @Override
    public JsonElement emptyList() {
        return new JsonArray();
    }

    @Override
    public Transcoder.ListBuilder<JsonElement> createList(int expectedSize) {
        final JsonArray list = new JsonArray(expectedSize);
        return new Transcoder.ListBuilder<JsonElement>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Transcoder.ListBuilder<JsonElement> add(JsonElement value) {
                list.add(value);
                return this;
            }

            @Override
            public JsonElement build() {
                return list;
            }
        };
    }

    @Override
    public Result<Transcoder.MapLike<JsonElement>> getMap(JsonElement value) {
        if (!(value instanceof JsonObject)) {
            return new Result.Error<Transcoder.MapLike<JsonElement>>("Not an object: " + String.valueOf(value));
        }
        final JsonObject object = (JsonObject)value;
        return new Result.Ok<Transcoder.MapLike<JsonElement>>(new Transcoder.MapLike<JsonElement>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Collection<String> keys() {
                return object.keySet();
            }

            @Override
            public boolean hasValue(String key) {
                return object.has(key);
            }

            @Override
            public Result<JsonElement> getValue(String key) {
                JsonElement element = object.get(key);
                if (element == null) {
                    return new Result.Error<JsonElement>("No such key: " + key);
                }
                return new Result.Ok<JsonElement>(element);
            }

            @Override
            public int size() {
                return object.size();
            }
        });
    }

    @Override
    public JsonElement emptyMap() {
        return new JsonObject();
    }

    @Override
    public Transcoder.MapBuilder<JsonElement> createMap() {
        final JsonObject object = new JsonObject();
        return new Transcoder.MapBuilder<JsonElement>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Transcoder.MapBuilder<JsonElement> put(JsonElement key, JsonElement value) {
                return this.put(key.getAsString(), value);
            }

            @Override
            public Transcoder.MapBuilder<JsonElement> put(String key, JsonElement value) {
                if (value != JsonNull.INSTANCE) {
                    object.add(key, value);
                }
                return this;
            }

            @Override
            public JsonElement build() {
                return object;
            }
        };
    }

    /*
     * Loose catch block
     */
    @Override
    public <O> Result<O> convertTo(Transcoder<O> coder, JsonElement value) {
        Result.Error error;
        JsonElement jsonElement = value;
        Objects.requireNonNull(jsonElement);
        JsonElement jsonElement2 = jsonElement;
        int n = 0;
        block21: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonObject.class, JsonArray.class, JsonPrimitive.class, JsonPrimitive.class, JsonPrimitive.class, JsonNull.class}, (JsonElement)jsonElement2, n)) {
                case 0: {
                    String key;
                    JsonObject object = (JsonObject)jsonElement2;
                    Transcoder.MapBuilder<O> mapBuilder = coder.createMap();
                    block22: for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
                        String string;
                        Result.Error error2;
                        Result<O> result;
                        key = entry.getKey();
                        Objects.requireNonNull(this.convertTo(coder, entry.getValue()));
                        int n2 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, result, n2)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                Result.Ok ok = (Result.Ok)result;
                                Result.Error data = error2 = ok.value();
                                mapBuilder.put(coder.createString(key), data);
                                continue block22;
                            }
                            case 1: 
                        }
                        error2 = (Result.Error)result;
                        String message = string = error2.message();
                        error = new Result.Error((String)key + ": " + message);
                        break block21;
                    }
                    error = new Result.Ok<O>(mapBuilder.build());
                    break block21;
                }
                case 1: {
                    String key;
                    JsonArray array = (JsonArray)jsonElement2;
                    if (array.isEmpty()) {
                        error = new Result.Ok<O>(coder.emptyList());
                        break block21;
                    }
                    Transcoder.ListBuilder<O> listBuilder = coder.createList(array.size());
                    block23: for (int i = 0; i < array.size(); ++i) {
                        Objects.requireNonNull(this.convertTo(coder, array.get(i)));
                        int n3 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, (Result)((Object)key), n3)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                Result.Error error3;
                                Result.Ok ok = (Result.Ok)((Object)key);
                                Result.Error data = error3 = ok.value();
                                listBuilder.add(data);
                                continue block23;
                            }
                            case 1: {
                                String string;
                                Result.Error error3 = (Result.Error)((Object)key);
                                String message = string = error3.message();
                                error = new Result.Error(i + ": " + message);
                                break block21;
                            }
                        }
                    }
                    error = new Result.Ok<O>(listBuilder.build());
                    break block21;
                }
                case 2: {
                    JsonPrimitive primitive = (JsonPrimitive)jsonElement2;
                    if (!primitive.isBoolean()) {
                        n = 3;
                        continue block21;
                    }
                    error = new Result.Ok<O>(coder.createBoolean(primitive.getAsBoolean()));
                    break block21;
                }
                case 3: {
                    JsonPrimitive primitive = (JsonPrimitive)jsonElement2;
                    if (!primitive.isNumber()) {
                        n = 4;
                        continue block21;
                    }
                    error = new Result.Ok<O>(coder.createDouble(primitive.getAsDouble()));
                    break block21;
                }
                case 4: {
                    JsonPrimitive primitive = (JsonPrimitive)jsonElement2;
                    if (!primitive.isString()) {
                        n = 5;
                        continue block21;
                    }
                    error = new Result.Ok<O>(coder.createString(primitive.getAsString()));
                    break block21;
                }
                case 5: {
                    JsonNull jsonNull = (JsonNull)jsonElement2;
                    error = new Result.Ok<O>(coder.createNull());
                    break block21;
                }
                default: {
                    error = new Result.Error("Unknown JSON type: " + String.valueOf(value));
                    break block21;
                }
            }
            break;
        }
        return error;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

