/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import net.minestom.server.coordinate.BlockVec;
import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;

public record BlockBoundingBox(Point min, Point max) {
    public static final NetworkBuffer.Type<BlockBoundingBox> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.BLOCK_POSITION, BlockBoundingBox::min, NetworkBuffer.BLOCK_POSITION, BlockBoundingBox::max, BlockBoundingBox::new);

    public BlockBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this(new BlockVec(minX, minY, minZ), new BlockVec(maxX, maxY, maxZ));
    }

    public int minX() {
        return this.min.blockX();
    }

    public int minY() {
        return this.min.blockY();
    }

    public int minZ() {
        return this.min.blockZ();
    }

    public int maxX() {
        return this.max.blockX();
    }

    public int maxY() {
        return this.max.blockY();
    }

    public int maxZ() {
        return this.max.blockZ();
    }
}

