/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.RayUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.BlockFace;
import org.jetbrains.annotations.Unmodifiable;

public record ShapeImpl(ShapeData shapeData, OcclusionData occlusionData) implements Shape
{
    private static final Pattern PATTERN = Pattern.compile("\\d.\\d+", 8);

    private static byte isFaceCovered(List<Rectangle> covering) {
        if (covering.isEmpty()) {
            return 0;
        }
        Rectangle r = new Rectangle(0.0, 0.0, 1.0, 1.0);
        ArrayList<Rectangle> toCover = new ArrayList<Rectangle>();
        toCover.add(r);
        for (Rectangle rect : covering) {
            ArrayList<Rectangle> nextCovering = new ArrayList<Rectangle>();
            for (Rectangle toCoverRect : toCover) {
                List<Rectangle> remaining = ShapeImpl.getRemaining(rect, toCoverRect);
                nextCovering.addAll(remaining);
            }
            toCover = nextCovering;
            if (!toCover.isEmpty()) continue;
            return 2;
        }
        return 1;
    }

    @Override
    public Point relativeStart() {
        return this.shapeData.relativeStart;
    }

    @Override
    public Point relativeEnd() {
        return this.shapeData.relativeEnd;
    }

    @Override
    public boolean isOccluded(Shape shape, BlockFace face) {
        boolean hasAirOcclusionOther;
        boolean hasBlockOcclusionOther;
        OcclusionData occlusionData = this.occlusionData;
        OcclusionData otherOcclusionData = ((ShapeImpl)shape).occlusionData;
        boolean hasBlockOcclusion = (occlusionData.blockOcclusion >> face.ordinal() & 1) == 1;
        boolean bl = hasBlockOcclusionOther = (otherOcclusionData.blockOcclusion >> face.getOppositeFace().ordinal() & 1) == 1;
        if (occlusionData.lightEmission > 0) {
            return hasBlockOcclusionOther;
        }
        if (hasBlockOcclusion || hasBlockOcclusionOther) {
            return true;
        }
        boolean hasAirOcclusion = (occlusionData.airOcclusion >> face.ordinal() & 1) == 1;
        boolean bl2 = hasAirOcclusionOther = (otherOcclusionData.airOcclusion >> face.getOppositeFace().ordinal() & 1) == 1;
        if (hasAirOcclusion || hasAirOcclusionOther) {
            return false;
        }
        ShapeData shapeData = this.shapeData;
        ShapeData otherShapeData = ((ShapeImpl)shape).shapeData;
        List<Rectangle> allRectangles = ShapeImpl.computeOcclusionSet(face.getOppositeFace(), otherShapeData.boundingBoxes);
        allRectangles.addAll(ShapeImpl.computeOcclusionSet(face, shapeData.boundingBoxes));
        return ShapeImpl.isFaceCovered(allRectangles) == 2;
    }

    @Override
    public boolean isFaceFull(BlockFace face) {
        return (this.shapeData.fullFaces >> face.ordinal() & 1) == 1;
    }

    @Override
    public boolean intersectBox(Point position, BoundingBox boundingBox) {
        for (BoundingBox blockSection : this.shapeData.boundingBoxes) {
            if (!boundingBox.intersectBox(position, blockSection)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectBoxSwept(Point rayStart, Point rayDirection, Point shapePos, BoundingBox moving, SweepResult finalResult) {
        boolean hitBlock = false;
        for (BoundingBox blockSection : this.shapeData.boundingBoxes) {
            if (!RayUtils.BoundingBoxIntersectionCheck(moving, rayStart, rayDirection, blockSection, shapePos, finalResult)) continue;
            finalResult.collidedPositionX = rayStart.x() + rayDirection.x() * finalResult.res;
            finalResult.collidedPositionY = rayStart.y() + rayDirection.y() * finalResult.res;
            finalResult.collidedPositionZ = rayStart.z() + rayDirection.z() * finalResult.res;
            finalResult.collidedShapeX = shapePos.x();
            finalResult.collidedShapeY = shapePos.y();
            finalResult.collidedShapeZ = shapePos.z();
            finalResult.collidedShape = this;
            hitBlock = true;
        }
        return hitBlock;
    }

    public @Unmodifiable List<BoundingBox> boundingBoxes() {
        return this.shapeData.boundingBoxes;
    }

    static ShapeImpl parseShapeFromRegistry(String shape, byte lightEmission) {
        BoundingBox[] boundingBoxes = ShapeImpl.parseRegistryBoundingBoxString(shape);
        ShapeData shapeData = ShapeImpl.shapeData(List.of(boundingBoxes));
        OcclusionData occlusionData = ShapeImpl.occlusionData(shapeData, lightEmission);
        return new ShapeImpl(shapeData, occlusionData);
    }

    static ShapeImpl emptyShape(byte lightEmission) {
        BoundingBox[] boundingBoxes = new BoundingBox[]{};
        ShapeData shapeData = ShapeImpl.shapeData(List.of(boundingBoxes));
        OcclusionData occlusionData = ShapeImpl.occlusionData(shapeData, lightEmission);
        return new ShapeImpl(shapeData, occlusionData);
    }

    private static BoundingBox[] parseRegistryBoundingBoxString(String str) {
        Matcher matcher = PATTERN.matcher(str);
        DoubleArrayList vals = new DoubleArrayList();
        while (matcher.find()) {
            double newVal = Double.parseDouble(matcher.group());
            vals.add(newVal);
        }
        int count = vals.size() / 6;
        BoundingBox[] boundingBoxes = new BoundingBox[count];
        for (int i = 0; i < count; ++i) {
            double minX = vals.getDouble(0 + 6 * i);
            double minY = vals.getDouble(1 + 6 * i);
            double minZ = vals.getDouble(2 + 6 * i);
            double boundXSize = vals.getDouble(3 + 6 * i) - minX;
            double boundYSize = vals.getDouble(4 + 6 * i) - minY;
            double boundZSize = vals.getDouble(5 + 6 * i) - minZ;
            Vec min = new Vec(minX, minY, minZ);
            Vec max = new Vec(minX + boundXSize, minY + boundYSize, minZ + boundZSize);
            BoundingBox bb = new BoundingBox(min, max);
            assert (bb.minX() == minX);
            assert (bb.minY() == minY);
            assert (bb.minZ() == minZ);
            boundingBoxes[i] = bb;
        }
        return boundingBoxes;
    }

    private static ShapeData shapeData(List<BoundingBox> collisionBoundingBoxes) {
        Vec relativeEnd;
        Vec relativeStart;
        if (!collisionBoundingBoxes.isEmpty()) {
            double minX = 1.0;
            double minY = 1.0;
            double minZ = 1.0;
            double maxX = 0.0;
            double maxY = 0.0;
            double maxZ = 0.0;
            for (BoundingBox blockSection : collisionBoundingBoxes) {
                if (blockSection.minX() < minX) {
                    minX = blockSection.minX();
                }
                if (blockSection.minY() < minY) {
                    minY = blockSection.minY();
                }
                if (blockSection.minZ() < minZ) {
                    minZ = blockSection.minZ();
                }
                if (blockSection.maxX() > maxX) {
                    maxX = blockSection.maxX();
                }
                if (blockSection.maxY() > maxY) {
                    maxY = blockSection.maxY();
                }
                if (!(blockSection.maxZ() > maxZ)) continue;
                maxZ = blockSection.maxZ();
            }
            relativeStart = new Vec(minX, minY, minZ);
            relativeEnd = new Vec(maxX, maxY, maxZ);
        } else {
            relativeStart = Vec.ZERO;
            relativeEnd = Vec.ZERO;
        }
        byte fullCollisionFaces = 0;
        for (BlockFace f : BlockFace.values()) {
            byte res = ShapeImpl.isFaceCovered(ShapeImpl.computeOcclusionSet(f, collisionBoundingBoxes));
            fullCollisionFaces = (byte)(fullCollisionFaces | (res == 2 ? (byte)1 : 0) << (byte)f.ordinal());
        }
        return new ShapeData(collisionBoundingBoxes, relativeStart, relativeEnd, fullCollisionFaces);
    }

    private static OcclusionData occlusionData(ShapeData shapeData, byte lightEmission) {
        byte fullFaces = 0;
        byte airFaces = 0;
        for (BlockFace f : BlockFace.values()) {
            byte res = ShapeImpl.isFaceCovered(ShapeImpl.computeOcclusionSet(f, shapeData.boundingBoxes));
            fullFaces = (byte)(fullFaces | (res == 2 ? (byte)1 : 0) << (byte)f.ordinal());
            airFaces = (byte)(airFaces | (res == 0 ? (byte)1 : 0) << (byte)f.ordinal());
        }
        return new OcclusionData(fullFaces, airFaces, lightEmission);
    }

    private static List<Rectangle> computeOcclusionSet(BlockFace face, List<BoundingBox> boundingBoxes) {
        ArrayList<Rectangle> rSet = new ArrayList<Rectangle>();
        for (BoundingBox boundingBox : boundingBoxes) {
            switch (face) {
                case NORTH: {
                    if (boundingBox.minZ() != 0.0) break;
                    rSet.add(new Rectangle(boundingBox.minX(), boundingBox.minY(), boundingBox.maxX(), boundingBox.maxY()));
                    break;
                }
                case SOUTH: {
                    if (boundingBox.maxZ() != 1.0) break;
                    rSet.add(new Rectangle(boundingBox.minX(), boundingBox.minY(), boundingBox.maxX(), boundingBox.maxY()));
                    break;
                }
                case WEST: {
                    if (boundingBox.minX() != 0.0) break;
                    rSet.add(new Rectangle(boundingBox.minY(), boundingBox.minZ(), boundingBox.maxY(), boundingBox.maxZ()));
                    break;
                }
                case EAST: {
                    if (boundingBox.maxX() != 1.0) break;
                    rSet.add(new Rectangle(boundingBox.minY(), boundingBox.minZ(), boundingBox.maxY(), boundingBox.maxZ()));
                    break;
                }
                case BOTTOM: {
                    if (boundingBox.minY() != 0.0) break;
                    rSet.add(new Rectangle(boundingBox.minX(), boundingBox.minZ(), boundingBox.maxX(), boundingBox.maxZ()));
                    break;
                }
                case TOP: {
                    if (boundingBox.maxY() != 1.0) break;
                    rSet.add(new Rectangle(boundingBox.minX(), boundingBox.minZ(), boundingBox.maxX(), boundingBox.maxZ()));
                }
            }
        }
        return rSet;
    }

    private static List<Rectangle> getRemaining(Rectangle covering, Rectangle toCover) {
        ArrayList<Rectangle> remaining = new ArrayList<Rectangle>();
        if ((covering = ShapeImpl.clipRectangle(covering, toCover)).y1() > toCover.y1()) {
            remaining.add(new Rectangle(toCover.x1(), toCover.y1(), toCover.x2(), covering.y1()));
        }
        if (covering.y2() < toCover.y2()) {
            remaining.add(new Rectangle(toCover.x1(), covering.y2(), toCover.x2(), toCover.y2()));
        }
        if (covering.x1() > toCover.x1()) {
            remaining.add(new Rectangle(toCover.x1(), covering.y1(), covering.x1(), covering.y2()));
        }
        if (covering.x2() < toCover.x2()) {
            remaining.add(new Rectangle(covering.x2(), covering.y1(), toCover.x2(), covering.y2()));
        }
        return remaining;
    }

    private static Rectangle clipRectangle(Rectangle covering, Rectangle toCover) {
        double x1 = Math.max(covering.x1(), toCover.x1());
        double y1 = Math.max(covering.y1(), toCover.y1());
        double x2 = Math.min(covering.x2(), toCover.x2());
        double y2 = Math.min(covering.y2(), toCover.y2());
        return new Rectangle(x1, y1, x2, y2);
    }

    record ShapeData(List<BoundingBox> boundingBoxes, Point relativeStart, Point relativeEnd, byte fullFaces) {
        public ShapeData {
            boundingBoxes = List.copyOf(boundingBoxes);
        }
    }

    record OcclusionData(byte blockOcclusion, byte airOcclusion, byte lightEmission) {
    }

    private record Rectangle(double x1, double y1, double x2, double y2) {
    }
}

