/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minestom.server.command.CommandParser;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.ConsoleSender;
import net.minestom.server.command.ExecutableCommand;
import net.minestom.server.command.Graph;
import net.minestom.server.command.GraphConverter;
import net.minestom.server.command.ServerSender;
import net.minestom.server.command.builder.Command;
import net.minestom.server.command.builder.CommandDispatcher;
import net.minestom.server.command.builder.CommandResult;
import net.minestom.server.command.builder.ParsedCommand;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.PlayerCommandEvent;
import net.minestom.server.network.packet.server.play.DeclareCommandsPacket;
import net.minestom.server.utils.callback.CommandCallback;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Nullable;

public final class CommandManager {
    public static final String COMMAND_PREFIX = "/";
    private final ServerSender serverSender = new ServerSender();
    private final ConsoleSender consoleSender = new ConsoleSender();
    private final CommandParser parser = CommandParser.parser();
    private final CommandDispatcher dispatcher = new CommandDispatcher(this);
    private final Map<String, Command> commandMap = new HashMap<String, Command>();
    private final Set<Command> commands = new HashSet<Command>();
    private CommandCallback unknownCommandCallback;
    @Nullable
    private volatile Graph cachedGraph;

    public synchronized void register(Command command) {
        Check.stateCondition(this.commandExists(command.getName()), "A command with the name " + command.getName() + " is already registered!");
        if (command.getAliases() != null) {
            for (String alias : command.getAliases()) {
                Check.stateCondition(this.commandExists(alias), "A command with the name " + alias + " is already registered!");
            }
        }
        this.commands.add(command);
        for (String name : command.getNames()) {
            this.commandMap.put(name, command);
        }
        this.invalidateGraphCache();
    }

    public synchronized void register(Command ... commands) {
        for (Command command : commands) {
            this.register(command);
        }
    }

    public void unregister(Command command) {
        this.commands.remove(command);
        for (String name : command.getNames()) {
            this.commandMap.remove(name);
        }
        this.invalidateGraphCache();
    }

    @Nullable
    public Command getCommand(String commandName) {
        return this.commandMap.get(commandName.toLowerCase(Locale.ROOT));
    }

    public boolean commandExists(String commandName) {
        return this.getCommand(commandName) != null;
    }

    public CommandResult execute(CommandSender sender, String command) {
        ExecutableCommand.Result executeResult;
        CommandParser.Result parsedCommand;
        ExecutableCommand executable;
        CommandResult result;
        command = command.trim();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            PlayerCommandEvent playerCommandEvent = new PlayerCommandEvent(player, command);
            EventDispatcher.call(playerCommandEvent);
            if (playerCommandEvent.isCancelled()) {
                return CommandResult.of(CommandResult.Type.CANCELLED, command);
            }
            command = playerCommandEvent.getCommand();
        }
        if ((result = CommandManager.resultConverter(executable = (parsedCommand = this.parseCommand(sender, command)).executable(), executeResult = executable.execute(sender), command)).getType() == CommandResult.Type.UNKNOWN && this.unknownCommandCallback != null) {
            this.unknownCommandCallback.apply(sender, command);
        }
        return result;
    }

    public CommandResult executeServerCommand(String command) {
        return this.execute(this.serverSender, command);
    }

    public CommandDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Nullable
    public CommandCallback getUnknownCommandCallback() {
        return this.unknownCommandCallback;
    }

    public void setUnknownCommandCallback(@Nullable CommandCallback unknownCommandCallback) {
        this.unknownCommandCallback = unknownCommandCallback;
    }

    public ConsoleSender getConsoleSender() {
        return this.consoleSender;
    }

    public DeclareCommandsPacket createDeclareCommandsPacket(Player player) {
        return GraphConverter.createPacket(this.getGraph(), player);
    }

    public Set<Command> getCommands() {
        return Collections.unmodifiableSet(this.commands);
    }

    public CommandParser.Result parseCommand(CommandSender sender, String input) {
        return this.parser.parse(sender, this.getGraph(), input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Graph getGraph() {
        Graph graph = this.cachedGraph;
        if (graph == null) {
            CommandManager commandManager = this;
            synchronized (commandManager) {
                graph = this.cachedGraph;
                if (graph == null) {
                    graph = this.cachedGraph = Graph.merge(this.getCommands());
                }
            }
        }
        return graph;
    }

    private void invalidateGraphCache() {
        this.cachedGraph = null;
    }

    private static CommandResult resultConverter(ExecutableCommand executable, ExecutableCommand.Result newResult, String input) {
        return CommandResult.of(switch (newResult.type()) {
            default -> throw new MatchException(null, null);
            case ExecutableCommand.Result.Type.SUCCESS -> CommandResult.Type.SUCCESS;
            case ExecutableCommand.Result.Type.CANCELLED, ExecutableCommand.Result.Type.PRECONDITION_FAILED, ExecutableCommand.Result.Type.EXECUTOR_EXCEPTION -> CommandResult.Type.CANCELLED;
            case ExecutableCommand.Result.Type.INVALID_SYNTAX -> CommandResult.Type.INVALID_SYNTAX;
            case ExecutableCommand.Result.Type.UNKNOWN -> CommandResult.Type.UNKNOWN;
        }, input, ParsedCommand.fromExecutable(executable), newResult.commandData());
    }
}

