/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.Graph;
import net.minestom.server.command.builder.Command;
import net.minestom.server.command.builder.CommandExecutor;
import net.minestom.server.command.builder.CommandSyntax;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.arguments.ArgumentCommand;
import net.minestom.server.command.builder.arguments.ArgumentLiteral;
import net.minestom.server.command.builder.arguments.ArgumentType;
import net.minestom.server.command.builder.condition.CommandCondition;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

final class GraphImpl
extends Record
implements Graph {
    private final NodeImpl root;

    GraphImpl(NodeImpl root) {
        this.root = root;
    }

    static GraphImpl fromCommand(Command command) {
        return new GraphImpl(NodeImpl.command(command));
    }

    static Graph merge(Collection<Command> commands) {
        return new GraphImpl(NodeImpl.rootCommands(commands));
    }

    static GraphImpl merge(List<Graph> graphs) {
        List<Graph.Node> children = graphs.stream().map(Graph::root).toList();
        NodeImpl root = new NodeImpl(ArgumentType.Literal(""), null, children);
        return new GraphImpl(root);
    }

    @Override
    public boolean compare(Graph graph, Graph.Comparator comparator) {
        return GraphImpl.compare(this.root, graph.root(), comparator);
    }

    static Argument<String> commandToArgument(Command command) {
        String[] aliases = command.getNames();
        if (aliases.length == 1) {
            return ArgumentType.Literal(aliases[0]);
        }
        return ArgumentType.Word(command.getName()).from(command.getNames());
    }

    static boolean compare(Graph.Node first, Graph.Node second, Graph.Comparator comparator) {
        boolean bl;
        block10: {
            switch (comparator) {
                default: {
                    throw new MatchException(null, null);
                }
                case TREE: 
            }
            if (!GraphImpl.compareExecution(first, second)) {
                bl = false;
            } else if (!first.argument().equals(second.argument())) {
                bl = false;
            } else if (first.next().size() != second.next().size()) {
                bl = false;
            } else {
                for (int i = 0; i < first.next().size(); ++i) {
                    if (GraphImpl.compare(first.next().get(i), second.next().get(i), comparator)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static boolean compareExecution(Graph.Node firstNode, Graph.Node secondNode) {
        Graph.Execution first = firstNode.execution();
        Graph.Execution second = secondNode.execution();
        boolean firstExecutor = first != null && first.executor() != null;
        boolean firstCondition = first != null && first.condition() != null;
        boolean secondExecutor = second != null && second.executor() != null;
        boolean secondCondition = second != null && second.condition() != null;
        return firstExecutor == secondExecutor && firstCondition == secondCondition;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{GraphImpl.class, "root", "root"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GraphImpl.class, "root", "root"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GraphImpl.class, "root", "root"}, this, o);
    }

    @Override
    public NodeImpl root() {
        return this.root;
    }

    static final class NodeImpl
    extends Record
    implements Graph.Node {
        private final Argument<?> argument;
        private final ExecutionImpl execution;
        private final List<Graph.Node> next;
        private static final Comparator<Graph.Node> nodePriority = (node1, node2) -> {
            int node1Value = NodeImpl.argumentValue(node1.argument());
            int node2Value = NodeImpl.argumentValue(node2.argument());
            return Integer.compare(node1Value, node2Value);
        };

        NodeImpl(Argument<?> argument, ExecutionImpl execution, List<Graph.Node> next) {
            this.argument = argument;
            this.execution = execution;
            this.next = next.stream().sorted(nodePriority).toList();
        }

        static NodeImpl fromBuilder(BuilderImpl builder) {
            List<BuilderImpl> children = builder.children;
            NodeImpl[] nodes = new NodeImpl[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                nodes[i] = NodeImpl.fromBuilder(children.get(i));
            }
            return new NodeImpl(builder.argument, (ExecutionImpl)builder.execution, List.of(nodes));
        }

        static NodeImpl command(Command command) {
            return ConversionNode.fromCommand(command).toNode();
        }

        static NodeImpl rootCommands(Collection<Command> commands) {
            return ConversionNode.rootConv(commands).toNode();
        }

        private static int argumentValue(Argument<?> argument) {
            if (argument.getClass() == ArgumentCommand.class) {
                return -3000;
            }
            if (argument.getClass() == ArgumentLiteral.class) {
                return -2000;
            }
            return -1000;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NodeImpl.class, "argument;execution;next", "argument", "execution", "next"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NodeImpl.class, "argument;execution;next", "argument", "execution", "next"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NodeImpl.class, "argument;execution;next", "argument", "execution", "next"}, this, o);
        }

        @Override
        public Argument<?> argument() {
            return this.argument;
        }

        @Override
        public ExecutionImpl execution() {
            return this.execution;
        }

        @Override
        public List<Graph.Node> next() {
            return this.next;
        }
    }

    record ExecutionImpl(@UnknownNullability Predicate<CommandSender> predicate, @UnknownNullability CommandExecutor defaultExecutor, @Nullable CommandExecutor globalListener, @Nullable CommandExecutor executor, @Nullable CommandCondition condition) implements Graph.Execution
    {
        @Override
        public boolean test(CommandSender commandSender) {
            return this.predicate.test(commandSender);
        }

        static ExecutionImpl fromCommand(Command command) {
            CommandExecutor defaultExecutor = command.getDefaultExecutor();
            CommandCondition defaultCondition = command.getCondition();
            CommandExecutor executor = defaultExecutor;
            CommandCondition condition = defaultCondition;
            for (CommandSyntax syntax : command.getSyntaxes()) {
                if (syntax.getArguments().length != 0) continue;
                executor = syntax.getExecutor();
                CommandCondition syntaxCondition = syntax.getCommandCondition();
                if (syntaxCondition != null && defaultCondition != null) {
                    condition = (sender, commandString) -> defaultCondition.canUse(sender, commandString) && syntaxCondition.canUse(sender, commandString);
                    break;
                }
                if (syntaxCondition == null) break;
                condition = syntaxCondition;
                break;
            }
            CommandExecutor globalListener = (sender, context) -> command.globalListener(sender, context, context.getInput());
            return new ExecutionImpl(commandSender -> defaultCondition == null || defaultCondition.canUse((CommandSender)commandSender, null), defaultExecutor, globalListener, executor, condition);
        }

        static ExecutionImpl fromSyntax(CommandSyntax syntax) {
            CommandExecutor executor = syntax.getExecutor();
            CommandCondition condition = syntax.getCommandCondition();
            return new ExecutionImpl(commandSender -> condition == null || condition.canUse((CommandSender)commandSender, null), null, null, executor, condition);
        }
    }

    private static final class ConversionNode {
        final Argument<?> argument;
        ExecutionImpl execution;
        final Map<Argument<?>, ConversionNode> nextMap;

        public ConversionNode(Argument<?> argument, ExecutionImpl execution, Map<Argument<?>, ConversionNode> nextMap) {
            this.argument = argument;
            this.execution = execution;
            this.nextMap = nextMap;
        }

        ConversionNode(Argument<?> argument, ExecutionImpl execution) {
            this(argument, execution, new LinkedHashMap());
        }

        private NodeImpl toNode() {
            NodeImpl[] nodes = new NodeImpl[this.nextMap.size()];
            int i = 0;
            for (ConversionNode entry : this.nextMap.values()) {
                nodes[i++] = entry.toNode();
            }
            return new NodeImpl(this.argument, this.execution, List.of(nodes));
        }

        static ConversionNode fromCommand(Command command) {
            ConversionNode root = new ConversionNode(GraphImpl.commandToArgument(command), ExecutionImpl.fromCommand(command));
            for (Command subcommand : command.getSubcommands()) {
                root.nextMap.put(GraphImpl.commandToArgument(subcommand), ConversionNode.fromCommand(subcommand));
            }
            for (CommandSyntax syntax : command.getSyntaxes()) {
                ConversionNode syntaxNode = root;
                for (Argument<?> arg : syntax.getArguments()) {
                    boolean last = arg == syntax.getArguments()[syntax.getArguments().length - 1];
                    ExecutionImpl ex = last ? ExecutionImpl.fromSyntax(syntax) : null;
                    syntaxNode = syntaxNode.nextMap.computeIfAbsent(arg, argument -> new ConversionNode((Argument<?>)argument, ex));
                    if (syntaxNode.execution != null) continue;
                    syntaxNode.execution = ex;
                }
            }
            return root;
        }

        static ConversionNode rootConv(Collection<Command> commands) {
            LinkedHashMap next = new LinkedHashMap(commands.size());
            for (Command command : commands) {
                ConversionNode conv = ConversionNode.fromCommand(command);
                next.put(conv.argument, conv);
            }
            return new ConversionNode(ArgumentType.Literal(""), null, next);
        }
    }

    record BuilderImpl(Argument<?> argument, List<BuilderImpl> children, Graph.Execution execution) implements Graph.Builder
    {
        public BuilderImpl(Argument<?> argument, Graph.Execution execution) {
            this(argument, new ArrayList<BuilderImpl>(), execution);
        }

        @Override
        public Graph.Builder append(Argument<?> argument, @Nullable Graph.Execution execution, Consumer<Graph.Builder> consumer) {
            BuilderImpl builder = new BuilderImpl(argument, execution);
            consumer.accept(builder);
            this.children.add(builder);
            return this;
        }

        @Override
        public Graph.Builder append(Argument<?> argument, @Nullable Graph.Execution execution) {
            this.children.add(new BuilderImpl(argument, List.of(), execution));
            return this;
        }

        @Override
        public GraphImpl build() {
            return new GraphImpl(NodeImpl.fromBuilder(this));
        }
    }
}

