/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minestom.server.command.builder.CommandData;
import net.minestom.server.command.builder.arguments.Argument;
import org.jetbrains.annotations.Nullable;

public class CommandContext {
    private final String input;
    private final String commandName;
    protected Map<String, Object> args = new HashMap<String, Object>();
    protected Map<String, String> rawArgs = new HashMap<String, String>();
    private CommandData returnData;

    public CommandContext(String input) {
        this.input = input;
        this.commandName = input.split(" ")[0];
    }

    public String getInput() {
        return this.input;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public <T> T get(Argument<T> argument) {
        return this.get(argument.getId());
    }

    public <T> T get(String identifier) {
        return (T)this.args.get(identifier);
    }

    public <T> T getOrDefault(Argument<T> argument, T defaultValue) {
        return this.getOrDefault(argument.getId(), defaultValue);
    }

    public <T> T getOrDefault(String identifier, T defaultValue) {
        T value = this.get(identifier);
        return value != null ? value : defaultValue;
    }

    public boolean has(Argument<?> argument) {
        return this.args.containsKey(argument.getId());
    }

    public boolean has(String identifier) {
        return this.args.containsKey(identifier);
    }

    @Nullable
    public CommandData getReturnData() {
        return this.returnData;
    }

    public void setReturnData(@Nullable CommandData returnData) {
        this.returnData = returnData;
    }

    public Map<String, Object> getMap() {
        return this.args;
    }

    public void copy(CommandContext context) {
        this.args = context.args;
        this.rawArgs = context.rawArgs;
    }

    public String getRaw(Argument<?> argument) {
        return this.rawArgs.get(argument.getId());
    }

    public String getRaw(String identifier) {
        return this.rawArgs.get(identifier);
    }

    public void setArg(String id, Object value, String rawInput) {
        this.args.put(id, value);
        this.rawArgs.put(id, rawInput);
    }

    protected void clear() {
        this.args.clear();
    }

    protected void retrieveDefaultValues(@Nullable Map<String, Supplier<Object>> defaultValuesMap) {
        if (defaultValuesMap == null) {
            return;
        }
        for (Map.Entry<String, Supplier<Object>> entry : defaultValuesMap.entrySet()) {
            String key = entry.getKey();
            if (this.args.containsKey(key)) continue;
            Supplier<Object> supplier = entry.getValue();
            this.args.put(key, supplier.get());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandContext)) {
            return false;
        }
        CommandContext that = (CommandContext)o;
        return Objects.equals(this.input, that.input) && Objects.equals(this.commandName, that.commandName) && Objects.equals(this.args, that.args) && Objects.equals(this.rawArgs, that.rawArgs) && Objects.equals(this.returnData, that.returnData);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.commandName, this.args, this.rawArgs, this.returnData);
    }
}

