/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.CommandExecutor;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.condition.CommandCondition;
import org.jetbrains.annotations.Nullable;

public class CommandSyntax {
    @Nullable
    private CommandCondition commandCondition;
    private CommandExecutor executor;
    @Nullable
    private final Map<String, Function<CommandSender, Object>> defaultValuesMap;
    private final Argument<?>[] args;
    private final boolean suggestion;

    protected CommandSyntax(@Nullable CommandCondition commandCondition, CommandExecutor commandExecutor, @Nullable Map<String, Function<CommandSender, Object>> defaultValuesMap, Argument<?> ... args) {
        this.commandCondition = commandCondition;
        this.executor = commandExecutor;
        this.defaultValuesMap = defaultValuesMap;
        this.args = args;
        this.suggestion = Arrays.stream(args).anyMatch(Argument::hasSuggestion);
    }

    protected CommandSyntax(@Nullable CommandCondition commandCondition, CommandExecutor commandExecutor, Argument<?> ... args) {
        this(commandCondition, commandExecutor, (Map<String, Function<CommandSender, Object>>)null, args);
    }

    @Nullable
    public CommandCondition getCommandCondition() {
        return this.commandCondition;
    }

    public void setCommandCondition(@Nullable CommandCondition commandCondition) {
        this.commandCondition = commandCondition;
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(CommandExecutor executor) {
        this.executor = executor;
    }

    @Nullable
    protected Map<String, Function<CommandSender, Object>> getDefaultValuesMap() {
        return this.defaultValuesMap;
    }

    public Argument<?>[] getArguments() {
        return this.args;
    }

    public boolean hasSuggestion() {
        return this.suggestion;
    }

    public String getSyntaxString() {
        StringBuilder builder = new StringBuilder();
        for (Argument<?> argument : this.args) {
            builder.append(argument.toString()).append(" ");
        }
        return builder.toString().trim();
    }
}

